/*
 * Decompiled with CFR 0.152.
 */
package atonkish.quartzelv.gametest.testcase;

import atonkish.quartzelv.QuartzElevatorMod;
import atonkish.quartzelv.block.ModBlocks;
import atonkish.quartzelv.gametest.util.MockServerPlayerHelper;
import atonkish.quartzelv.gametest.util.TestFunction;
import atonkish.quartzelv.gametest.util.TestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4516;

public class TeleportTests {
    private static final String TEST_ENVIRONMENT_DEFAULT = String.format("%s:teleport/default", "quartzelv");
    private static final String TEST_ENVIRONMENT_WITH_MIX_TYPES = String.format("%s:teleport/with_mix_types", "quartzelv");
    private static final String TEST_ENVIRONMENT_WITH_PLAYER_ONLY = String.format("%s:teleport/with_player_only", "quartzelv");
    private static final String TEST_STRUCTURE_EMPTY = "fabric-gametest-api-v1:empty";
    public static final Collection<TestFunction> TEST_FUNCTIONS = new ArrayList<TestFunction>(){
        {
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Smooth Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Smooth Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Smooth Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Smooth Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, false));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, class_1299.field_6051, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, class_1299.field_6051, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, class_1299.field_6069, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, class_1299.field_6069, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Quartz Elevator to Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, class_1299.field_6102, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator", TEST_ENVIRONMENT_DEFAULT, class_1299.field_6102, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Quartz Elevator to Smooth Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 17, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player does not teleport up from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player does not teleport down from Smooth Quartz Elevator to Quartz Elevator with mix types enabled", TEST_ENVIRONMENT_WITH_MIX_TYPES, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 65, false));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Quartz Elevator to Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, true));
            this.add(TeleportTests.createTestPlayerTeleportUp("Player teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestPlayerTeleportDown("Player teleport down from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, true));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, class_1299.field_6051, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, false));
            this.add(TeleportTests.createTestMobTeleportUp("Zombie teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, class_1299.field_6051, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, false));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, class_1299.field_6069, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, false));
            this.add(TeleportTests.createTestMobTeleportUp("Slime teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, class_1299.field_6069, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, false));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Quartz Elevator to Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, class_1299.field_6102, ModBlocks.QUARTZ_ELEVATOR_BLOCK, ModBlocks.QUARTZ_ELEVATOR_BLOCK, 16, false));
            this.add(TeleportTests.createTestMobTeleportUp("Magma Cube teleport up from Smooth Quartz Elevator to Smooth Quartz Elevator with player only enabled", TEST_ENVIRONMENT_WITH_PLAYER_ONLY, class_1299.field_6102, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, ModBlocks.SMOOTH_QUARTZ_ELEVATOR, 64, false));
        }
    };

    private static void beforeTest(class_4516 context, String environment) {
        if (environment == TEST_ENVIRONMENT_WITH_MIX_TYPES) {
            QuartzElevatorMod.CONFIG.quartzElevatorDistance = 16;
            QuartzElevatorMod.CONFIG.smoothQuartzElevatorDistance = 64;
            QuartzElevatorMod.CONFIG.mixTypes = true;
            QuartzElevatorMod.CONFIG.isPlayerOnly = false;
            QuartzElevatorMod.CONFIG.displayParticles = true;
        } else if (environment == TEST_ENVIRONMENT_WITH_PLAYER_ONLY) {
            QuartzElevatorMod.CONFIG.quartzElevatorDistance = 16;
            QuartzElevatorMod.CONFIG.smoothQuartzElevatorDistance = 64;
            QuartzElevatorMod.CONFIG.mixTypes = false;
            QuartzElevatorMod.CONFIG.isPlayerOnly = true;
            QuartzElevatorMod.CONFIG.displayParticles = true;
        } else {
            QuartzElevatorMod.CONFIG.quartzElevatorDistance = 16;
            QuartzElevatorMod.CONFIG.smoothQuartzElevatorDistance = 64;
            QuartzElevatorMod.CONFIG.mixTypes = false;
            QuartzElevatorMod.CONFIG.isPlayerOnly = false;
            QuartzElevatorMod.CONFIG.displayParticles = true;
        }
    }

    private static TestFunction createTestPlayerTeleportUp(String name, String environment, class_2248 elevatorBlock1, class_2248 elevatorBlock2, int distance, boolean shouldTeleport) {
        class_2960 testIdentifier = TestIdentifier.of("quartzelv", TeleportTests.class, name);
        return new TestFunction(testIdentifier, environment, TEST_STRUCTURE_EMPTY, 20, 0, true, class_2470.field_11467, false, 1, 1, false, context -> {
            TeleportTests.beforeTest(context, environment);
            class_2338 blockPos1 = class_2338.field_10980;
            class_2338 blockPos2 = class_2338.field_10980.method_10086(distance);
            context.method_35984(blockPos1, elevatorBlock1);
            context.method_35984(blockPos2, elevatorBlock2);
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)blockPos1.method_10086(1)));
            CompletableFuture futurePartialAct1 = new CompletableFuture();
            CompletableFuture futurePartialAct2 = new CompletableFuture();
            long tickOrigin = 0L;
            context.method_35951(tickOrigin, () -> {
                player.method_6043();
                futurePartialAct1.complete(null);
            });
            long tickAfterTeleporting = 1L;
            context.method_35951(tickAfterTeleporting, () -> futurePartialAct2.complete(null));
            CompletableFuture.allOf(futurePartialAct1, futurePartialAct2).thenRun(() -> {
                try {
                    context.method_35955((class_1297)player, (shouldTeleport ? blockPos2 : blockPos1).method_10086(1));
                }
                catch (Exception e) {
                    QuartzElevatorMod.LOGGER.error("[{}] {}", (Object)testIdentifier, (Object)e.getMessage());
                    throw e;
                }
                finally {
                    MockServerPlayerHelper.destroy(context, player);
                }
                context.method_36036();
            });
            context.method_36036();
        });
    }

    private static <E extends class_1308> TestFunction createTestMobTeleportUp(String name, String environment, class_1299<E> type, class_2248 elevatorBlock1, class_2248 elevatorBlock2, int distance, boolean shouldTeleport) {
        class_2960 testIdentifier = TestIdentifier.of("quartzelv", TeleportTests.class, name);
        return new TestFunction(testIdentifier, environment, TEST_STRUCTURE_EMPTY, 20, 0, true, class_2470.field_11467, false, 1, 1, false, context -> {
            class_2338 blockPos1 = class_2338.field_10980;
            class_2338 blockPos2 = class_2338.field_10980.method_10086(distance);
            context.method_35984(blockPos1, elevatorBlock1);
            context.method_35984(blockPos2, elevatorBlock2);
            class_1308 mob = context.method_36009(type, blockPos1.method_10086(1));
            CompletableFuture futurePartialAct1 = new CompletableFuture();
            CompletableFuture futurePartialAct2 = new CompletableFuture();
            long tickOrigin = 0L;
            context.method_35951(tickOrigin, () -> TeleportTests.lambda$createTestMobTeleportUp$4((class_1309)mob, futurePartialAct1));
            long tickAfterTeleporting = 1L;
            context.method_35951(tickAfterTeleporting, () -> futurePartialAct2.complete(null));
            CompletableFuture.allOf(futurePartialAct1, futurePartialAct2).thenRun(() -> TeleportTests.lambda$createTestMobTeleportUp$6(context, (class_1309)mob, shouldTeleport, blockPos2, blockPos1, testIdentifier));
            context.method_36036();
        });
    }

    private static TestFunction createTestPlayerTeleportDown(String name, String environment, class_2248 elevatorBlock1, class_2248 elevatorBlock2, int distance, boolean shouldTeleport) {
        class_2960 testIdentifier = TestIdentifier.of("quartzelv", TeleportTests.class, name);
        return new TestFunction(testIdentifier, environment, TEST_STRUCTURE_EMPTY, 20, 0, true, class_2470.field_11467, false, 1, 1, false, context -> {
            class_2338 blockPos1 = class_2338.field_10980.method_10086(distance);
            class_2338 blockPos2 = class_2338.field_10980;
            context.method_35984(blockPos1, elevatorBlock1);
            context.method_35984(blockPos2, elevatorBlock2);
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)blockPos1.method_10086(1)));
            CompletableFuture futurePartialAct1 = new CompletableFuture();
            CompletableFuture futurePartialAct2 = new CompletableFuture();
            long tickOrigin = 0L;
            context.method_35951(tickOrigin, () -> {
                player.method_5660(true);
                player.method_5660(false);
                futurePartialAct1.complete(null);
            });
            long tickAfterTeleporting = 1L;
            context.method_35951(tickAfterTeleporting, () -> futurePartialAct2.complete(null));
            CompletableFuture.allOf(futurePartialAct1, futurePartialAct2).thenRun(() -> {
                try {
                    context.method_35955((class_1297)player, (shouldTeleport ? blockPos2 : blockPos1).method_10086(1));
                }
                catch (Exception e) {
                    QuartzElevatorMod.LOGGER.error("[{}] {}", (Object)testIdentifier, (Object)e.getMessage());
                    throw e;
                }
                finally {
                    MockServerPlayerHelper.destroy(context, player);
                }
                context.method_36036();
            });
            context.method_36036();
        });
    }

    private static /* synthetic */ void lambda$createTestMobTeleportUp$6(class_4516 context, class_1309 mob, boolean shouldTeleport, class_2338 blockPos2, class_2338 blockPos1, class_2960 testIdentifier) {
        try {
            context.method_35955((class_1297)mob, (shouldTeleport ? blockPos2 : blockPos1).method_10086(1));
        }
        catch (Exception e) {
            QuartzElevatorMod.LOGGER.error("[{}] {}", (Object)testIdentifier, (Object)e.getMessage());
            throw e;
        }
        context.method_36036();
    }

    private static /* synthetic */ void lambda$createTestMobTeleportUp$4(class_1309 mob, CompletableFuture futurePartialAct1) {
        mob.method_6043();
        futurePartialAct1.complete(null);
    }
}

