/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.ohmymeteors.mixin;

import java.util.List;
import java.util.function.BooleanSupplier;
import me.emafire003.dev.ohmymeteors.compat.flan.FlanCompat;
import me.emafire003.dev.ohmymeteors.compat.yawp.YawpCompat;
import me.emafire003.dev.ohmymeteors.config.Config;
import me.emafire003.dev.ohmymeteors.entities.MeteorProjectileEntity;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2802;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5269;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class WorldSpawnMeteorMixin
extends class_1937
implements class_5281 {
    @Unique
    int meteorCooldown = 0;

    protected WorldSpawnMeteorMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, boolean isClient, boolean debugWorld, long seed, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Shadow
    @Nullable
    public abstract class_3222 method_18779();

    @Shadow
    public abstract boolean method_8649(class_1297 var1);

    @Shadow
    public abstract class_2802 method_8398();

    @Shadow
    public abstract class_3218 method_8410();

    @Shadow
    public abstract List<class_3222> method_18456();

    @Inject(method={"method_18765(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="TAIL")})
    public void tickSpawnMeteor(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (Config.SHOULD_COOLDOWN_BETWEEN_METEORS && this.meteorCooldown > 0) {
            --this.meteorCooldown;
            return;
        }
        class_3222 p = this.method_18779();
        if (p == null) {
            return;
        }
        if (FabricLoader.getInstance().isModLoaded("flan") && !FlanCompat.canSpawnHere(p, p.method_24515())) {
            return;
        }
        if (FabricLoader.getInstance().isModLoaded("yawp") && !YawpCompat.canSpawnHere((class_3218)this, p.method_24515()) && !YawpCompat.canSpawnHere((class_3218)this, new class_2338(p.method_24515().method_10263(), Config.METEOR_SPAWN_HEIGHT, p.method_24515().method_10260()))) {
            return;
        }
        class_6880 current_dim = p.method_51469().method_40134();
        if (!MeteorProjectileEntity.canSpawnInDimension((class_6880<class_2874>)current_dim)) {
            return;
        }
        class_6880 current_biome = p.method_51469().method_23753(p.method_24515());
        if (!MeteorProjectileEntity.canSpawnInBiome((class_6880<class_1959>)current_biome)) {
            return;
        }
        int chance = Config.METEOR_SPAWN_CHANCE;
        if (Config.DIMENSION_CHANCES.containsKey(current_dim.method_55840())) {
            chance = Config.DIMENSION_CHANCES.get(current_dim.method_55840());
        }
        if (Config.BIOME_CHANCES.containsKey(current_biome.method_55840())) {
            chance = Config.BIOME_CHANCES.get(current_biome.method_55840());
        }
        if (Config.MODIFY_SPAWN_CHANCE_AT_NIGHT && this.method_23886()) {
            chance = Config.METEOR_NIGHT_SPAWN_CHANCE;
            if (Config.DIMENSION_NIGHT_CHANCES.containsKey(current_dim.method_55840())) {
                chance = Config.DIMENSION_NIGHT_CHANCES.get(current_dim.method_55840());
            }
            if (Config.BIOME_NIGHT_CHANCES.containsKey(current_biome.method_55840())) {
                chance = Config.BIOME_NIGHT_CHANCES.get(current_biome.method_55840());
            }
        }
        if (this.method_8409().method_39332(0, chance) == 0) {
            MeteorProjectileEntity.spawnMeteor((class_3218)this, (class_1657)p);
            if (Config.SHOULD_COOLDOWN_BETWEEN_METEORS) {
                this.meteorCooldown = 20 * Config.MIN_METEOR_COOLDOWN_TIME;
            }
        }
    }

    @Unique
    public boolean checkDimension(class_6880<class_2874> current_dim) {
        return Config.SPAWN_DIMENSIONS.contains(current_dim.method_55840());
    }

    @Unique
    public boolean checkBiome(class_6880<class_1959> current_biome) {
        if (Config.BIOME_LIST_MODE) {
            return Config.BIOME_SPAWN_LIST.contains(current_biome.method_55840());
        }
        return !Config.BIOME_SPAWN_LIST.contains(current_biome.method_55840());
    }
}

