/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.ohmymeteors.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10209;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_4770;
import net.minecraft.class_5134;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class SphereExplosion
implements class_1927 {
    private static final class_5362 DEFAULT_BEHAVIOR = new class_5362();
    private static final int field_52618 = 16;
    private static final float field_52619 = 2.0f;
    private final boolean createFire;
    private final class_1927.class_4179 destructionType;
    private final class_3218 world;
    private final class_243 pos;
    @Nullable
    private final class_1297 entity;
    private final float power;
    private final class_1282 damageSource;
    private final class_5362 behavior;
    private final Map<class_1657, class_243> knockbackByPlayer = new HashMap<class_1657, class_243>();
    protected double thetaRef;
    protected double phiRef;
    private static final int MAX_POWER = 255;

    public SphereExplosion(class_3218 world, @Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 behavior, class_243 pos, float power, boolean createFire, class_1927.class_4179 destructionType) {
        this.world = world;
        this.entity = entity;
        this.power = power;
        this.pos = pos;
        this.createFire = createFire;
        this.destructionType = destructionType;
        this.damageSource = damageSource == null ? world.method_48963().method_48807((class_1927)this) : damageSource;
        this.behavior = behavior == null ? this.makeBehavior(entity) : behavior;
    }

    private class_5362 makeBehavior(@Nullable class_1297 entity) {
        return entity == null ? DEFAULT_BEHAVIOR : new class_5361(entity);
    }

    public static float calculateReceivedDamage(class_243 pos, class_1297 entity) {
        class_238 box = entity.method_5829();
        double d = 1.0 / ((box.field_1320 - box.field_1323) * 2.0 + 1.0);
        double e = 1.0 / ((box.field_1325 - box.field_1322) * 2.0 + 1.0);
        double f = 1.0 / ((box.field_1324 - box.field_1321) * 2.0 + 1.0);
        double g = (1.0 - Math.floor(1.0 / d) * d) / 2.0;
        double h = (1.0 - Math.floor(1.0 / f) * f) / 2.0;
        if (!(d < 0.0 || e < 0.0 || f < 0.0)) {
            int i = 0;
            int j = 0;
            for (double k = 0.0; k <= 1.0; k += d) {
                for (double l = 0.0; l <= 1.0; l += e) {
                    for (double m = 0.0; m <= 1.0; m += f) {
                        double n = class_3532.method_16436((double)k, (double)box.field_1323, (double)box.field_1320);
                        double o = class_3532.method_16436((double)l, (double)box.field_1322, (double)box.field_1325);
                        double p = class_3532.method_16436((double)m, (double)box.field_1321, (double)box.field_1324);
                        class_243 vec3d = new class_243(n + g, o, p + h);
                        if (entity.method_73183().method_17742(new class_3959(vec3d, pos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity)).method_17783() == class_239.class_240.field_1333) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public float method_55107() {
        return this.power;
    }

    public class_243 method_55109() {
        return this.pos;
    }

    private List<class_2338> getBlocksToDestroy() {
        HashSet<class_2338> set = new HashSet<class_2338>();
        int i = 16;
        for (int j = 15; j < 16; ++j) {
            for (int k = 15; k < 16; ++k) {
                block2: for (int l = 0; l < (int)Math.max(this.power * this.power, 255.0f); ++l) {
                    double d = this.calcDakaXdirection(l);
                    double e = Math.sin(this.phiRef) * Math.sin(this.thetaRef);
                    double f = Math.cos(this.phiRef);
                    double g = 1.0;
                    d /= g;
                    e /= g;
                    f /= g;
                    double m = this.pos.field_1352;
                    double n = this.pos.field_1351;
                    double o = this.pos.field_1350;
                    float p = 0.3f;
                    for (float h = this.power * (0.7f + this.world.field_9229.method_43057() * 0.6f); h > 0.0f; h -= 0.22500001f) {
                        class_2338 blockPos = class_2338.method_49637((double)m, (double)n, (double)o);
                        class_2680 blockState = this.world.method_8320(blockPos);
                        class_3610 fluidState = this.world.method_8316(blockPos);
                        if (!this.world.method_24794(blockPos)) continue block2;
                        Optional optional = this.behavior.method_29555((class_1927)this, (class_1922)this.world, blockPos, blockState, fluidState);
                        if (optional.isPresent()) {
                            h -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (h > 0.0f && this.behavior.method_29554((class_1927)this, (class_1922)this.world, blockPos, blockState, h)) {
                            set.add(blockPos);
                        }
                        m += d * (double)0.3f;
                        n += e * (double)0.3f;
                        o += f * (double)0.3f;
                    }
                }
            }
        }
        return new ObjectArrayList(set);
    }

    private void damageEntities() {
        float f = this.power * 2.0f;
        int i = class_3532.method_15357((double)(this.pos.field_1352 - (double)f - 1.0));
        int j = class_3532.method_15357((double)(this.pos.field_1352 + (double)f + 1.0));
        int k = class_3532.method_15357((double)(this.pos.field_1351 - (double)f - 1.0));
        int l = class_3532.method_15357((double)(this.pos.field_1351 + (double)f + 1.0));
        int m = class_3532.method_15357((double)(this.pos.field_1350 - (double)f - 1.0));
        int n = class_3532.method_15357((double)(this.pos.field_1350 + (double)f + 1.0));
        for (class_1297 entity : this.world.method_8335(this.entity, new class_238((double)i, (double)k, (double)m, (double)j, (double)l, (double)n))) {
            class_1657 playerEntity;
            double s;
            float q;
            double h;
            double g;
            double e;
            double o;
            double d;
            if (entity.method_5659((class_1927)this) || !((d = Math.sqrt(entity.method_5707(this.pos)) / (double)f) <= 1.0) || (o = Math.sqrt((e = entity.method_23317() - this.pos.field_1352) * e + (g = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.pos.field_1351) * g + (h = entity.method_23321() - this.pos.field_1350) * h)) == 0.0) continue;
            e /= o;
            g /= o;
            h /= o;
            boolean bl = this.behavior.method_55504((class_1927)this, entity);
            float p = this.behavior.method_57007(entity);
            float f2 = q = !bl && p == 0.0f ? 0.0f : SphereExplosion.calculateReceivedDamage(this.pos, entity);
            if (bl) {
                entity.method_64397(this.world, this.damageSource, this.behavior.method_55115((class_1927)this, entity, q));
            }
            double r = (1.0 - d) * (double)q * (double)p;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                s = r * (1.0 - livingEntity.method_45325(class_5134.field_51580));
            } else {
                s = r;
            }
            class_243 vec3d = new class_243(e *= s, g *= s, h *= s);
            entity.method_60491(vec3d);
            if (!(!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).method_7325() || playerEntity.method_68878() && playerEntity.method_31549().field_7479)) {
                this.knockbackByPlayer.put(playerEntity, vec3d);
            }
            entity.method_56918(this.entity);
        }
    }

    private void destroyBlocks(List<class_2338> positions) {
        ArrayList list = new ArrayList();
        class_156.method_43028(positions, (class_5819)this.world.field_9229);
        for (class_2338 blockPos : positions) {
            this.world.method_8320(blockPos).method_55225(this.world, blockPos, (class_1927)this, (item, pos) -> SphereExplosion.addDroppedItem(list, item, pos));
        }
        for (DroppedItem droppedItem : list) {
            class_2248.method_9577((class_1937)this.world, (class_2338)droppedItem.pos, (class_1799)droppedItem.item);
        }
    }

    private void createFire(List<class_2338> positions) {
        for (class_2338 blockPos : positions) {
            if (this.world.field_9229.method_43048(3) != 0 || !this.world.method_8320(blockPos).method_26215() || !this.world.method_8320(blockPos.method_10074()).method_26216()) continue;
            this.world.method_8501(blockPos, class_4770.method_24416((class_1922)this.world, (class_2338)blockPos));
        }
    }

    private static void addDroppedItem(List<DroppedItem> droppedItemsOut, class_1799 item, class_2338 pos) {
        for (DroppedItem droppedItem : droppedItemsOut) {
            droppedItem.merge(item);
            if (!item.method_7960()) continue;
            return;
        }
        droppedItemsOut.add(new DroppedItem(pos, item));
    }

    private boolean shouldDestroyBlocks() {
        return this.destructionType != class_1927.class_4179.field_40878;
    }

    public Map<class_1657, class_243> getKnockbackByPlayer() {
        return this.knockbackByPlayer;
    }

    public class_3218 method_64504() {
        return this.world;
    }

    @Nullable
    public class_1309 method_8347() {
        return class_1927.method_55110((class_1297)this.entity);
    }

    @Nullable
    public class_1297 method_46406() {
        return this.entity;
    }

    public class_1282 getDamageSource() {
        return this.damageSource;
    }

    public class_1927.class_4179 method_55111() {
        return this.destructionType;
    }

    public boolean method_60274() {
        if (this.destructionType != class_1927.class_4179.field_47331) {
            return false;
        }
        return this.entity != null && this.entity.method_5864() == class_1299.field_49075 ? this.world.method_64395().method_8355(class_1928.field_19388) : true;
    }

    public boolean method_61722() {
        boolean bl2;
        boolean bl = this.world.method_64395().method_8355(class_1928.field_19388);
        boolean bl3 = bl2 = this.entity == null || this.entity.method_5864() != class_1299.field_49075 && this.entity.method_5864() != class_1299.field_47243;
        return bl ? bl2 : this.destructionType.method_61723() && bl2;
    }

    public boolean isSmall() {
        return this.power < 2.0f || !this.shouldDestroyBlocks();
    }

    public double calcDakaXdirection(int l) {
        double theta;
        double phi = Math.acos(1.0 - 2.0 * (double)l / (double)((int)Math.max(this.power * this.power, 255.0f)));
        this.thetaRef = theta = Math.PI * (1.0 + Math.sqrt(5.0)) * (double)l;
        this.phiRef = phi;
        return Math.sin(phi) * Math.cos(theta);
    }

    public int explode() {
        this.world.method_43275(this.entity, (class_6880)class_5712.field_28178, this.pos);
        List<class_2338> list = this.getBlocksToDestroy();
        this.damageEntities();
        if (this.shouldDestroyBlocks()) {
            class_3695 profiler = class_10209.method_64146();
            profiler.method_15396("explosion_blocks");
            this.destroyBlocks(list);
            profiler.method_15407();
        }
        if (this.createFire) {
            this.createFire(list);
        }
        return list.size();
    }

    static class DroppedItem {
        final class_2338 pos;
        class_1799 item;

        DroppedItem(class_2338 pos, class_1799 item) {
            this.pos = pos;
            this.item = item;
        }

        public void merge(class_1799 other) {
            if (class_1542.method_24017((class_1799)this.item, (class_1799)other)) {
                this.item = class_1542.method_24018((class_1799)this.item, (class_1799)other, (int)16);
            }
        }
    }
}

