/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Transaction;
import ovh.mythmc.banco.api.callback.transaction.BancoTransactionQueue;
import ovh.mythmc.banco.api.callback.transaction.BancoTransactionQueueCallback;

public abstract class BancoScheduler {
    private final ScheduledExecutorService asyncScheduler = Executors.newScheduledThreadPool(1);
    private final List<Transaction> transactionQueue = new ArrayList<Transaction>();
    private static BancoScheduler bancoScheduler;

    public static void set(@NotNull BancoScheduler s2) {
        if (bancoScheduler == null) {
            bancoScheduler = s2;
        }
    }

    public static BancoScheduler get() {
        return bancoScheduler;
    }

    public void initialize() {
        this.runTask();
    }

    public abstract void run(@NotNull Runnable var1);

    public abstract void runAsync(@NotNull Runnable var1);

    public List<Transaction> getQueuedTransactions() {
        return List.copyOf(this.transactionQueue);
    }

    public void queueTransaction(Transaction transaction) {
        BancoTransactionQueue callback = new BancoTransactionQueue(transaction.asImmutable(), this.transactionQueue.size() + 1);
        BancoTransactionQueueCallback.INSTANCE.invoke(callback);
        if (callback.cancelled()) {
            return;
        }
        this.transactionQueue.add(transaction);
    }

    public void terminate() {
        this.asyncScheduler.close();
        this.transactionQueue.forEach(transaction -> transaction.transact());
    }

    private void runTask() {
        this.asyncScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!BancoScheduler.this.transactionQueue.isEmpty()) {
                    Transaction transaction = BancoScheduler.this.transactionQueue.getFirst();
                    switch (Banco.get().getSettings().get().getTaskExecutionOrder()) {
                        case SYNC: {
                            bancoScheduler.run(() -> transaction.transact());
                            break;
                        }
                        case ASYNC: {
                            bancoScheduler.runAsync(() -> transaction.transact());
                        }
                    }
                    BancoScheduler.this.transactionQueue.removeFirst();
                }
                BancoScheduler.this.runTask();
            }
        }, (long)(Banco.get().getSettings().get().getTaskQueueDelay() * 50), TimeUnit.MILLISECONDS);
    }
}

