/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import ovh.mythmc.banco.api.storage.BancoContainer;

public final class ShulkerBoxContainerImpl
extends BancoContainer {
    @Override
    public String friendlyName() {
        return "SHULKER_BOX";
    }

    @Override
    public Collection<ItemStack> get(UUID uuid) {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return allItems;
        }
        allItems.addAll(this.getItemsFromShulkers(player.getInventory().getContents()));
        allItems.addAll(this.getItemsFromShulkers(player.getEnderChest().getContents()));
        return allItems;
    }

    @Override
    protected ItemStack addItem(UUID uuid, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return itemStack;
        }
        itemStack = this.addToShulkers(player.getInventory().getContents(), itemStack);
        if (itemStack == null || itemStack.getAmount() <= 0) {
            return null;
        }
        itemStack = this.addToShulkers(player.getEnderChest().getContents(), itemStack);
        return itemStack;
    }

    @Override
    protected ItemStack removeItem(UUID uuid, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return itemStack;
        }
        itemStack = this.removeFromShulkers(player.getInventory().getContents(), itemStack);
        if (itemStack == null || itemStack.getAmount() <= 0) {
            return null;
        }
        itemStack = this.removeFromShulkers(player.getEnderChest().getContents(), itemStack);
        return itemStack;
    }

    private ItemStack addToShulkers(ItemStack[] stacks, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        for (ItemStack shulker : stacks) {
            BlockStateMeta meta = this.getShulkerMeta(shulker);
            if (meta == null || !(meta.getBlockState() instanceof ShulkerBox)) continue;
            ShulkerBox box = (ShulkerBox)meta.getBlockState();
            Inventory inv = box.getInventory();
            HashMap leftovers = inv.addItem(new ItemStack[]{itemStack.clone()});
            meta.setBlockState((BlockState)box);
            shulker.setItemMeta((ItemMeta)meta);
            if (leftovers.isEmpty()) {
                return null;
            }
            int remaining = leftovers.values().stream().mapToInt(ItemStack::getAmount).sum();
            itemStack = itemStack.clone();
            itemStack.setAmount(remaining);
        }
        return itemStack;
    }

    private ItemStack removeFromShulkers(ItemStack[] stacks, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        int toRemove = itemStack.getAmount();
        for (ItemStack shulker : stacks) {
            BlockStateMeta meta = this.getShulkerMeta(shulker);
            if (meta == null || !(meta.getBlockState() instanceof ShulkerBox)) continue;
            ShulkerBox box = (ShulkerBox)meta.getBlockState();
            Inventory inv = box.getInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack content = inv.getItem(i);
                if (content == null || !content.isSimilar(itemStack)) continue;
                int removed = Math.min(content.getAmount(), toRemove);
                content.setAmount(content.getAmount() - removed);
                toRemove -= removed;
                if (content.getAmount() <= 0) {
                    inv.setItem(i, null);
                }
                meta.setBlockState((BlockState)box);
                shulker.setItemMeta((ItemMeta)meta);
                if (toRemove > 0) continue;
                return null;
            }
        }
        if (toRemove <= 0) {
            return null;
        }
        ItemStack remainder = itemStack.clone();
        remainder.setAmount(toRemove);
        return remainder;
    }

    private Collection<ItemStack> getItemsFromShulkers(ItemStack[] stacks) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack shulker : stacks) {
            BlockStateMeta meta = this.getShulkerMeta(shulker);
            if (meta == null || !(meta.getBlockState() instanceof ShulkerBox)) continue;
            ShulkerBox box = (ShulkerBox)meta.getBlockState();
            for (ItemStack item : box.getInventory().getContents()) {
                if (item == null || item.getType().isAir()) continue;
                items.add(item.clone());
            }
        }
        return items;
    }

    private boolean isShulkerBox(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return item.getType().name().endsWith("SHULKER_BOX");
    }

    private BlockStateMeta getShulkerMeta(ItemStack shulker) {
        if (shulker == null || !this.isShulkerBox(shulker)) {
            return null;
        }
        try {
            ItemMeta meta = shulker.getItemMeta();
            if (!(meta instanceof BlockStateMeta)) {
                shulker.setItemMeta(Bukkit.getItemFactory().asMetaFor(meta, shulker.getType()));
                meta = shulker.getItemMeta();
            }
            return meta instanceof BlockStateMeta ? (BlockStateMeta)meta : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

