/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.translation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import lombok.Generated;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationStore;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.logger.LoggerWrapper;
import ovh.mythmc.banco.common.translation.MapResourceBundle;

public final class BancoLocalization {
    private final List<String> langs = List.of("ca_ES", "de_DE", "en_US", "es_ES", "fr_FR", "pt_BR", "ru_RU", "uk_UA", "zh_CN");
    private final File baseFile;
    private final LoggerWrapper logger = new LoggerWrapper(this){

        @Override
        public void info(String message, Object ... args) {
            Banco.get().getLogger().info("[i10n] " + message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            Banco.get().getLogger().warn("[i10n] " + message, args);
        }

        @Override
        public void error(String message, Object ... args) {
            Banco.get().getLogger().error("[i10n] " + message, args);
        }
    };

    public void load() {
        Path overrides = Paths.get(String.valueOf(this.baseFile) + "/lang/overrides.properties", new String[0]);
        if (!Files.exists(overrides, new LinkOption[0])) {
            try {
                if (!Files.isDirectory(overrides.getParent(), new LinkOption[0])) {
                    Files.createDirectories(overrides.getParent(), new FileAttribute[0]);
                }
                this.logger.info("Creating lang/overrides.properties...", new Object[0]);
                Files.copy(Objects.requireNonNull(Banco.class.getResourceAsStream("/overrides.properties")), overrides, new CopyOption[0]);
                this.logger.info("Done!", new Object[0]);
            }
            catch (IOException e) {
                this.logger.error("Error while creating overrides file: {}", e);
            }
        }
        TranslationStore.StringBased store = TranslationStore.messageFormat((Key)Key.key((String)"banco:i10n"));
        this.langs.forEach(arg_0 -> this.lambda$load$1((TranslationStore)store, overrides, arg_0));
        store.defaultLocale(Locale.forLanguageTag(Banco.get().getSettings().get().getDefaultLanguageTag()));
        GlobalTranslator.translator().addSource((Translator)store);
    }

    private ResourceBundle override(Path overrides, ResourceBundle bundle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (BufferedReader reader = Files.newBufferedReader(overrides, StandardCharsets.UTF_8);){
            PropertyResourceBundle overridesBundle = new PropertyResourceBundle(reader);
            for (String k : bundle.keySet()) {
                if (overridesBundle.containsKey(k)) {
                    map.put(k, overridesBundle.getObject(k));
                    continue;
                }
                map.put(k, bundle.getObject(k));
            }
        }
        catch (IOException e) {
            this.logger.error("Error while reading overrides file: {}", e);
        }
        return new MapResourceBundle(map);
    }

    @Generated
    public BancoLocalization(File baseFile) {
        this.baseFile = baseFile;
    }

    private /* synthetic */ void lambda$load$1(TranslationStore store, Path overrides, String langTag) {
        String baseName = "i10n_" + langTag;
        Locale locale = Locale.forLanguageTag(langTag.replace("_", "-"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale, UTF8ResourceBundleControl.utf8ResourceBundleControl());
        store.registerAll(locale, this.override(overrides, resourceBundle).keySet(), key -> {
            String format = resourceBundle.getString((String)key);
            return new MessageFormat(format, locale);
        });
    }
}

