/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.update;

import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.util.Objects;
import java.util.Scanner;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.logger.LoggerWrapper;

public final class UpdateChecker {
    private static final String url = "https://raw.githubusercontent.com/myth-MC/banco/main/VERSION";
    private static String latest = Banco.get().version();
    private static final ScheduledExecutorService asyncScheduler = Executors.newScheduledThreadPool(1);
    private static boolean running = false;
    private static final LoggerWrapper logger = new LoggerWrapper(){

        @Override
        public void info(String message, Object ... args) {
            Banco.get().getLogger().info("[update-checker] " + message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            Banco.get().getLogger().warn("[update-checker] " + message, args);
        }

        @Override
        public void error(String message, Object ... args) {
            Banco.get().getLogger().error("[update-checker] " + message, args);
        }
    };

    private static void scheduleTask() {
        if (!Banco.get().getSettings().get().getUpdateChecker().isEnabled()) {
            return;
        }
        asyncScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                UpdateChecker.performTask();
            }
        }, (long)Banco.get().getSettings().get().getUpdateChecker().getIntervalInHours(), TimeUnit.HOURS);
    }

    private static void performTask() {
        block17: {
            URLConnection connection = null;
            try {
                connection = URI.create(url).toURL().openConnection();
            }
            catch (IOException e) {
                if (Banco.get().getSettings().get().isDebug()) {
                    logger.warn("The update checker is not available:", new Object[0]);
                    e.printStackTrace();
                }
                return;
            }
            try (Scanner scanner = new Scanner(Objects.requireNonNull(connection).getInputStream());){
                if (Banco.get().getSettings().get().isDebug()) {
                    logger.info("Checking for updates...", new Object[0]);
                }
                String latest = scanner.next();
                UpdateChecker.setLatest(latest);
                if (UpdateChecker.isDevelopmentBuild(latest)) {
                    if (Banco.get().getSettings().get().isDebug()) {
                        logger.warn("This server is running a development build!", new Object[0]);
                    }
                    return;
                }
                if (!Banco.get().version().equals(latest)) {
                    logger.info("A new update has been found: " + latest + " (currently running " + Banco.get().version() + ")", new Object[0]);
                    logger.info("https://github.com/myth-MC/banco/releases/" + latest, new Object[0]);
                    return;
                }
                if (Banco.get().getSettings().get().isDebug()) {
                    logger.info("No updates have been found.", new Object[0]);
                }
            }
            catch (IOException e) {
                if (!Banco.get().getSettings().get().isDebug()) break block17;
                e.printStackTrace();
            }
        }
        UpdateChecker.scheduleTask();
    }

    private static boolean isDevelopmentBuild(String latest) {
        latest = latest.replace(".", "").replace("v", "");
        String currentVersion = Banco.get().version().replace(".", "").replace("v", "");
        return Integer.parseInt(currentVersion) > Integer.parseInt(latest);
    }

    public static void startTask() {
        if (running) {
            return;
        }
        running = true;
        asyncScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                UpdateChecker.performTask();
            }
        }, 1L, TimeUnit.MINUTES);
    }

    @Generated
    private UpdateChecker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static String getLatest() {
        return latest;
    }

    @Generated
    private static void setLatest(String latest) {
        UpdateChecker.latest = latest;
    }

    @Generated
    public static boolean isRunning() {
        return running;
    }
}

