/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.accounts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.accounts.AccountIdentifierKey;
import ovh.mythmc.banco.api.accounts.database.MySQLConnectionSource;
import ovh.mythmc.banco.api.accounts.database.SQLiteConnectionSource;
import ovh.mythmc.banco.api.configuration.sections.DatabaseConfig;
import ovh.mythmc.banco.api.logger.LoggerWrapper;
import ovh.mythmc.banco.libs.com.j256.ormlite.dao.Dao;
import ovh.mythmc.banco.libs.com.j256.ormlite.dao.DaoManager;
import ovh.mythmc.banco.libs.com.j256.ormlite.jdbc.JdbcConnectionSource;
import ovh.mythmc.banco.libs.com.j256.ormlite.support.ConnectionSource;
import ovh.mythmc.banco.libs.com.j256.ormlite.table.TableUtils;

public final class AccountDatabase {
    private final ScheduledExecutorService asyncScheduler = Executors.newScheduledThreadPool(1);
    private Dao<Account, UUID> accountsDao;
    private JdbcConnectionSource connectionSource;
    private final Map<AccountIdentifierKey, Account> cache = new ConcurrentHashMap<AccountIdentifierKey, Account>();
    private final Set<AccountIdentifierKey> accountIdentifierCache = ConcurrentHashMap.newKeySet();
    private boolean firstBoot = false;
    private String path;
    private final LoggerWrapper logger = new LoggerWrapper(this){

        @Override
        public void info(String message, Object ... args) {
            Banco.get().getLogger().info("[database] " + message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            Banco.get().getLogger().warn("[database] " + message, args);
        }

        @Override
        public void error(String message, Object ... args) {
            Banco.get().getLogger().error("[database] " + message, args);
        }
    };

    public void initialize(@NotNull String path) throws SQLException {
        this.connectionSource = switch (Banco.get().getSettings().get().getDatabase().getType()) {
            default -> throw new MatchException(null, null);
            case DatabaseConfig.DatabaseType.SQLITE -> new SQLiteConnectionSource(path);
            case DatabaseConfig.DatabaseType.MYSQL -> new MySQLConnectionSource();
        };
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, Account.class);
        this.accountsDao = DaoManager.createDao((ConnectionSource)this.connectionSource, Account.class);
        this.path = path;
        this.firstBoot = !Banco.get().getSettings().get().getDatabase().isInitialized() && Banco.get().getSettings().get().getDatabase().getDatabaseVersion() == 0;
        this.backup("backup");
        this.upgrade();
        this.scheduleAutoSaver();
        if (Banco.get().getSettings().get().isDebug()) {
            Banco.get().getLogger().info("Loaded a total amount of " + this.get().size() + " accounts! (using V3 format)", new Object[0]);
        }
        this.accountIdentifierCache.addAll(this.get().stream().map(Account::getIdentifier).toList());
        Banco.get().getSettings().setDatabaseInitialized();
    }

    private Dao<Account, UUID> getDao() {
        try {
            this.connectionSource.initialize();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        return this.accountsDao;
    }

    public void backup(String differentiator) {
        File file = new File(this.path);
        File oldFile = new File(this.path + "." + differentiator);
        try {
            Files.deleteIfExists(oldFile.toPath());
            Files.copy(file.toPath(), new FileOutputStream(oldFile));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public void shutdown() {
        this.updateAllDatabaseEntries();
    }

    public void create(@NotNull Account account) {
        try {
            this.getDao().createIfNotExists(account);
            this.accountIdentifierCache.add(account.getIdentifier());
            this.cache.put(account.getIdentifier(), account);
        }
        catch (SQLException e) {
            this.logger.error("Exception while creating account {}", e);
        }
    }

    public void delete(@NotNull Account account) {
        try {
            this.getDao().delete(account);
            this.accountIdentifierCache.remove(account.getIdentifier());
        }
        catch (SQLException e) {
            this.logger.error("Exception while deleting account {}", e);
        }
    }

    public void update(@NotNull Account account) {
        this.cache.put(account.getIdentifier(), account);
    }

    private void scheduleAutoSaver() {
        this.asyncScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                AccountDatabase.this.updateAllDatabaseEntries();
                AccountDatabase.this.scheduleAutoSaver();
            }
        }, (long)Banco.get().getSettings().get().getDatabase().getCacheClearInterval(), TimeUnit.MINUTES);
    }

    private void updateAllDatabaseEntries() {
        long startTime = System.currentTimeMillis();
        if (Banco.get().getSettings().get().isDebug()) {
            Banco.get().getLogger().info("Updating " + this.cache.size() + " cached accounts...", new Object[0]);
        }
        Map.copyOf(this.cache).values().forEach(this::updateDatabaseEntry);
        if (Banco.get().getSettings().get().isDebug()) {
            Banco.get().getLogger().info("Done! (took " + (System.currentTimeMillis() - startTime) + "ms)", new Object[0]);
        }
    }

    private void updateDatabaseEntry(@NotNull Account account) {
        try {
            this.getDao().update(account);
            this.cache.remove(account.getIdentifier());
        }
        catch (SQLException e) {
            this.logger.error("Exception while updating account {}", e);
        }
    }

    public Collection<Account> getCachedAccounts() {
        return this.cache.values();
    }

    public Collection<AccountIdentifierKey> getAccountIdentifierCache() {
        return this.accountIdentifierCache;
    }

    public List<Account> get() {
        try {
            return this.getDao().queryForAll();
        }
        catch (SQLException e) {
            this.logger.error("Exception while getting every account {}", e);
            return null;
        }
    }

    public Account getByUuid(@NotNull UUID uuid) {
        Account cachedAccount = this.findCachedAccountByUuid(uuid);
        if (cachedAccount != null) {
            return cachedAccount;
        }
        try {
            Account account = this.getDao().queryForId(uuid);
            if (account == null) {
                return null;
            }
            this.cache.put(account.getIdentifier(), account);
            return account;
        }
        catch (SQLException e) {
            this.logger.error("Exception while getting account {}", e);
            return null;
        }
    }

    public Account getByName(@NotNull String name) {
        Account cachedAccount = this.findCachedAccountByName(name);
        if (cachedAccount != null) {
            return cachedAccount;
        }
        try {
            List accounts = this.getDao().queryBuilder().where().like("name", name).query();
            if (accounts != null && !accounts.isEmpty()) {
                Account account = (Account)accounts.getFirst();
                this.cache.put(account.getIdentifier(), account);
                return account;
            }
        }
        catch (SQLException e) {
            this.logger.error("Exception while getting account {}", e);
        }
        return null;
    }

    public Account getByNameOrUuid(@NotNull String name, UUID uuid) {
        block4: {
            Account cachedAccount = this.findCachedAccountByName(name);
            if (cachedAccount != null) {
                return cachedAccount;
            }
            try {
                List accounts = this.getDao().queryBuilder().where().like("name", name).query();
                if (accounts != null && !accounts.isEmpty()) {
                    Account account = (Account)accounts.getFirst();
                    this.cache.put(account.getIdentifier(), account);
                    return account;
                }
            }
            catch (SQLException e) {
                if (uuid == null) break block4;
                return this.getByUuid(uuid);
            }
        }
        return null;
    }

    private Account findCachedAccountByUuid(@NotNull UUID uuid) {
        return Set.copyOf(this.cache.entrySet()).stream().filter(entry -> ((AccountIdentifierKey)entry.getKey()).uuid().equals(uuid)).map(entry -> (Account)entry.getValue()).findFirst().orElse(null);
    }

    private Account findCachedAccountByName(@NotNull String name) {
        return Set.copyOf(this.cache.entrySet()).stream().filter(entry -> ((AccountIdentifierKey)entry.getKey()).name() != null).filter(entry -> ((AccountIdentifierKey)entry.getKey()).name().equalsIgnoreCase(name)).map(entry -> (Account)entry.getValue()).findFirst().orElse(null);
    }

    public void upgrade() {
        int oldVersion = Banco.get().getSettings().get().getDatabase().getDatabaseVersion();
        if (oldVersion == 1) {
            try {
                this.logger.info("Upgrading database...", new Object[0]);
                this.getDao().executeRaw("ALTER TABLE `accounts` ADD COLUMN name STRING;", new String[0]);
                this.logger.info("Done!", new Object[0]);
            }
            catch (SQLException e) {
                if (e.getMessage().contains("Could not run raw execute statement ALTER TABLE `accounts` ADD COLUMN name STRING")) {
                    return;
                }
                this.logger.error("Exception while upgrading database: {}", e);
            }
        }
        if (!this.firstBoot) {
            // empty if block
        }
        Banco.get().getSettings().updateVersion(2);
    }

    @Generated
    public AccountDatabase() {
    }
}

