/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.accounts;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.accounts.AccountDatabase;
import ovh.mythmc.banco.api.accounts.Transaction;
import ovh.mythmc.banco.api.accounts.service.LocalUUIDResolver;
import ovh.mythmc.banco.api.accounts.service.OfflinePlayerReference;
import ovh.mythmc.banco.api.callback.account.BancoAccountRegister;
import ovh.mythmc.banco.api.callback.account.BancoAccountRegisterCallback;
import ovh.mythmc.banco.api.callback.account.BancoAccountUnregister;
import ovh.mythmc.banco.api.callback.account.BancoAccountUnregisterCallback;
import ovh.mythmc.banco.api.storage.BancoStorage;

public final class AccountManager {
    private final LocalUUIDResolver uuidResolver;
    private final AccountDatabase database = new AccountDatabase();

    public synchronized void create(@NotNull UUID uuid) {
        Account account = new Account();
        account.setUuid(uuid);
        account.setAmount(BigDecimal.ZERO);
        account.setTransactions(BigDecimal.ZERO);
        this.create(account);
    }

    public synchronized void create(@NotNull UUID uuid, @NotNull String name) {
        Account account = new Account();
        account.setUuid(uuid);
        account.setName(name);
        account.setAmount(BigDecimal.ZERO);
        account.setTransactions(BigDecimal.ZERO);
        this.create(account);
    }

    public synchronized void create(@NotNull Account account) {
        BancoAccountRegister callback = new BancoAccountRegister(account);
        BancoAccountRegisterCallback.INSTANCE.invoke(callback, result -> this.database.create(result.account()));
    }

    public synchronized void delete(@NotNull Account account) {
        BancoAccountUnregister callback = new BancoAccountUnregister(account);
        BancoAccountUnregisterCallback.INSTANCE.invoke(callback, result -> this.database.delete(result.account()));
    }

    public synchronized void delete(@NotNull UUID uuid) {
        this.delete(this.getByUuid(uuid));
    }

    @NotNull
    public List<Account> get() {
        return this.database.get();
    }

    public Account getByUuid(@NotNull UUID uuid) {
        return this.database.getByUuid(uuid);
    }

    public Account getByName(@NotNull String name) {
        return this.database.getByNameOrUuid(name, this.uuidResolver.resolve(name).orElse(null));
    }

    public void deposit(@NotNull UUID uuid, @NotNull BigDecimal amount) {
        this.deposit(this.getByUuid(uuid), amount);
    }

    public void deposit(@NotNull Account account, @NotNull BigDecimal amount) {
        Transaction transaction = Transaction.builder().account(account).amount(amount).operation(Transaction.Operation.DEPOSIT).build();
        transaction.queue();
    }

    public void withdraw(@NotNull UUID uuid, @NotNull BigDecimal amount) {
        this.withdraw(this.getByUuid(uuid), amount);
    }

    public void withdraw(@NotNull Account account, @NotNull BigDecimal amount) {
        Transaction transaction = Transaction.builder().account(account).amount(amount).operation(Transaction.Operation.WITHDRAW).build();
        transaction.queue();
    }

    public void set(@NotNull UUID uuid, @NotNull BigDecimal amount) {
        this.set(this.getByUuid(uuid), amount);
    }

    public void set(@NotNull Account account, @NotNull BigDecimal amount) {
        Transaction transaction = Transaction.builder().account(account).amount(amount).operation(Transaction.Operation.SET).build();
        transaction.queue();
    }

    public boolean has(@NotNull UUID uuid, @NotNull BigDecimal amount) {
        return this.has(this.getByUuid(uuid), amount);
    }

    public boolean has(@NotNull Account account, @NotNull BigDecimal amount) {
        return account.amount().compareTo(amount) >= 0;
    }

    @NotNull
    public BigDecimal amount(@NotNull UUID uuid) {
        return this.amount(this.getByUuid(uuid));
    }

    @NotNull
    public BigDecimal amount(@NotNull Account account) {
        Optional<OfflinePlayerReference> optionalOfflinePlayerReference = this.uuidResolver.resolveOfflinePlayer(account.getUuid());
        if (optionalOfflinePlayerReference.isPresent() && this.uuidResolver.resolveOfflinePlayer(account.getUuid()).get().toOfflinePlayer().isOnline()) {
            account.setAmount(this.getValueOfPlayer(account.getUuid(), true));
            this.database.update(account);
        }
        return account.getTransactions().add(this.getValueOfPlayer(account.getUuid(), false)).add(account.getAmount());
    }

    @ApiStatus.Internal
    private synchronized BigDecimal getValueOfPlayer(@NotNull UUID uuid, boolean isOnline) {
        BigDecimal value = BigDecimal.valueOf(0L);
        for (BancoStorage storage : Banco.get().getStorageRegistry().getByOrder()) {
            if (!isOnline && !storage.supportsOfflinePlayers()) continue;
            value = value.add(storage.value(uuid));
        }
        return value;
    }

    @ApiStatus.Internal
    public synchronized void updateTransactions(@NotNull Account account) {
        BigDecimal amount = account.amount();
        account.setTransactions(BigDecimal.valueOf(0L));
        this.database.update(account);
        this.set(account.getUuid(), amount);
    }

    @ApiStatus.Internal
    public void updateName(@NotNull Account account, String newName) {
        account.setName(newName);
        this.database.update(account);
    }

    public CompletableFuture<LinkedHashMap<UUID, BigDecimal>> getTopAsync(int limit) {
        return CompletableFuture.supplyAsync(() -> this.getTop(limit));
    }

    public LinkedHashMap<UUID, BigDecimal> getTop(int limit) {
        LinkedHashMap<UUID, BigDecimal> values = new LinkedHashMap<UUID, BigDecimal>();
        for (Account account : this.get()) {
            values.put(account.getUuid(), account.amount());
        }
        return values.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(limit).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public Map.Entry<UUID, BigDecimal> getTopPosition(int position) {
        return this.getTop(position).lastEntry();
    }

    @Generated
    public AccountManager(LocalUUIDResolver uuidResolver) {
        this.uuidResolver = uuidResolver;
    }

    @Generated
    public LocalUUIDResolver getUuidResolver() {
        return this.uuidResolver;
    }

    @Generated
    public AccountDatabase getDatabase() {
        return this.database;
    }
}

