/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.callback.storage.BancoStorageUnregister;
import ovh.mythmc.banco.api.storage.BancoStorage;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoStorageUnregisterCallback {
    public static final BancoStorageUnregisterCallback INSTANCE = new BancoStorageUnregisterCallback();
    private final HashMap<String, BancoStorageUnregisterCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoStorageUnregisterCallbackListener> callbackListeners = new HashMap();

    private BancoStorageUnregisterCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoStorageUnregisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoStorageUnregisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoStorageUnregisterCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoStorageUnregisterCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoStorageUnregister callback, Consumer<BancoStorageUnregister> result) {
        for (BancoStorageUnregisterCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoStorageUnregisterCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.bancoStorage()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoStorageUnregister callback, Consumer<BancoStorageUnregister> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoStorageUnregister callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoStorageUnregister callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoStorageUnregisterCallbackHandler {
        public void handle(BancoStorageUnregister var1);
    }

    @FunctionalInterface
    public static interface BancoStorageUnregisterCallbackListener {
        public void trigger(BancoStorage var1);
    }
}

