/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.accounts.Transaction;
import ovh.mythmc.banco.api.callback.transaction.BancoTransactionProcess;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoTransactionProcessCallback {
    public static final BancoTransactionProcessCallback INSTANCE = new BancoTransactionProcessCallback();
    private final HashMap<String, BancoTransactionProcessCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoTransactionProcessCallbackListener> callbackListeners = new HashMap();

    private BancoTransactionProcessCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoTransactionProcessCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoTransactionProcessCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoTransactionProcessCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoTransactionProcessCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoTransactionProcess callback, Consumer<BancoTransactionProcess> result) {
        for (BancoTransactionProcessCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoTransactionProcessCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.transaction(), callback.cancelled()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoTransactionProcess callback, Consumer<BancoTransactionProcess> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoTransactionProcess callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoTransactionProcess callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoTransactionProcessCallbackHandler {
        public void handle(BancoTransactionProcess var1);
    }

    @FunctionalInterface
    public static interface BancoTransactionProcessCallbackListener {
        public void trigger(Transaction var1, boolean var2);
    }
}

