/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.accounts.Transaction;
import ovh.mythmc.banco.api.callback.transaction.BancoTransactionQueue;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoTransactionQueueCallback {
    public static final BancoTransactionQueueCallback INSTANCE = new BancoTransactionQueueCallback();
    private final HashMap<String, BancoTransactionQueueCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoTransactionQueueCallbackListener> callbackListeners = new HashMap();

    private BancoTransactionQueueCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoTransactionQueueCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoTransactionQueueCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoTransactionQueueCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoTransactionQueueCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoTransactionQueue callback, Consumer<BancoTransactionQueue> result) {
        for (BancoTransactionQueueCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoTransactionQueueCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.transaction(), callback.position(), callback.cancelled()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoTransactionQueue callback, Consumer<BancoTransactionQueue> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoTransactionQueue callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoTransactionQueue callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoTransactionQueueCallbackHandler {
        public void handle(BancoTransactionQueue var1);
    }

    @FunctionalInterface
    public static interface BancoTransactionQueueCallbackListener {
        public void trigger(Transaction.ImmutableView var1, int var2, boolean var3);
    }
}

