/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.configuration;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.configuration.BancoSettings;
import ovh.mythmc.banco.libs.de.exlll.configlib.YamlConfigurationProperties;
import ovh.mythmc.banco.libs.de.exlll.configlib.YamlConfigurations;

public final class BancoSettingsProvider {
    private BancoSettings settings = new BancoSettings();
    private final Path settingsFilePath;

    public BancoSettingsProvider(@NotNull File pluginFolder) {
        this.settingsFilePath = new File(pluginFolder, "settings.yml").toPath();
    }

    public void load() {
        this.settings = YamlConfigurations.update(this.settingsFilePath, BancoSettings.class, ((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).build());
    }

    public void updateVersion(int newVersion) {
        this.settings.getDatabase().setVersion(newVersion);
        YamlConfigurations.save(this.settingsFilePath, BancoSettings.class, this.settings);
    }

    public void setDatabaseInitialized() {
        this.settings.getDatabase().setDatabaseInitialized();
        YamlConfigurations.save(this.settingsFilePath, BancoSettings.class, this.settings);
    }

    public BancoSettings get() {
        return this.settings;
    }
}

