/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.bukkit;

import lombok.Generated;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.AccountManager;
import ovh.mythmc.banco.api.accounts.service.defaults.BukkitLocalUUIDResolver;
import ovh.mythmc.banco.api.logger.LoggerWrapper;
import ovh.mythmc.banco.api.scheduler.BancoScheduler;
import ovh.mythmc.banco.bukkit.BancoBukkitPlugin;
import ovh.mythmc.banco.bukkit.BukkitCommandSource;
import ovh.mythmc.banco.bukkit.scheduler.BancoSchedulerBukkit;
import ovh.mythmc.banco.common.boot.BancoBootstrap;
import ovh.mythmc.banco.common.command.BancoCommandProvider;
import ovh.mythmc.banco.common.command.sender.BancoCommandSource;
import ovh.mythmc.banco.common.listeners.CustomItemListener;
import ovh.mythmc.banco.common.listeners.InventoryListener;
import ovh.mythmc.banco.common.listeners.ItemDropListener;
import ovh.mythmc.banco.common.listeners.PlayerListener;
import ovh.mythmc.gestalt.loader.BukkitGestaltLoader;

public final class BancoBukkit
extends BancoBootstrap {
    public static BancoBukkit instance;
    private static BukkitAudiences adventure;
    private BukkitGestaltLoader gestalt;
    private final BancoScheduler scheduler = new BancoSchedulerBukkit(this.getPlugin());
    private final BukkitLocalUUIDResolver uuidResolver;
    private final AccountManager accountManager;
    private final LoggerWrapper logger = new LoggerWrapper(){

        @Override
        public void info(String message, Object ... args) {
            BancoBukkit.this.getPlugin().getLogger().info(this.buildFullMessage(message, args));
        }

        @Override
        public void warn(String message, Object ... args) {
            BancoBukkit.this.getPlugin().getLogger().warning(this.buildFullMessage(message, args));
        }

        @Override
        public void error(String message, Object ... args) {
            BancoBukkit.this.getPlugin().getLogger().severe(this.buildFullMessage(message, args));
        }
    };

    public BancoBukkit(@NotNull BancoBukkitPlugin plugin) {
        super(plugin, plugin.getDataFolder(), BancoBukkit.provider(plugin));
        instance = this;
        this.uuidResolver = new BukkitLocalUUIDResolver(this.scheduler);
        this.accountManager = new AccountManager(this.uuidResolver);
    }

    @Override
    public void loadGestalt() {
        this.gestalt = BukkitGestaltLoader.builder().initializer(this.getPlugin()).build();
        this.gestalt.initialize();
    }

    @Override
    public void enable() {
        adventure = BukkitAudiences.create((Plugin)this.getPlugin());
        this.registerListeners();
        this.scheduler.initialize();
    }

    @Override
    public void disable() {
        this.gestalt.terminate();
        this.scheduler.terminate();
    }

    @Override
    public BancoScheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public String version() {
        return this.getPlugin().getDescription().getVersion();
    }

    private void registerListeners() {
        if (Banco.get().getSettings().get().getCurrency().isRemoveDrops()) {
            Bukkit.getPluginManager().registerEvents((Listener)new ItemDropListener(), (Plugin)this.getPlugin());
        }
        Bukkit.getPluginManager().registerEvents((Listener)new CustomItemListener(), (Plugin)this.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.uuidResolver, (Plugin)this.getPlugin());
    }

    @NotNull
    public static BukkitAudiences adventure() {
        if (adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return adventure;
    }

    private static BancoCommandProvider provider(@NotNull JavaPlugin plugin) {
        LegacyPaperCommandManager<BancoCommandSource> commandManager = new LegacyPaperCommandManager<BancoCommandSource>((Plugin)plugin, ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(commandSender -> new BukkitCommandSource((CommandSender)commandSender), bancoSource -> (CommandSender)bancoSource.source()));
        return new BancoCommandProvider(commandManager);
    }

    @Generated
    public BukkitGestaltLoader getGestalt() {
        return this.gestalt;
    }

    @Generated
    public BancoScheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public BukkitLocalUUIDResolver getUuidResolver() {
        return this.uuidResolver;
    }

    @Override
    @Generated
    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    @Override
    @Generated
    public LoggerWrapper getLogger() {
        return this.logger;
    }
}

