/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.command.commands;

import java.math.BigDecimal;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.standard.DoubleParser;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.common.command.MainCommand;
import ovh.mythmc.banco.common.command.parser.AccountParser;
import ovh.mythmc.banco.common.command.sender.BancoCommandSource;
import ovh.mythmc.banco.common.util.MessageUtil;

public final class PayCommand
implements MainCommand {
    @Override
    public boolean canRegister() {
        return Banco.get().getSettings().get().getCommands().getPay().enabled();
    }

    @Override
    public void register(@NotNull CommandManager<BancoCommandSource> commandManager) {
        Command.Builder<BancoCommandSource> payCommand = commandManager.commandBuilder("pay", new String[0]).permission("banco.use.pay").commandDescription(Description.of("Transfers money into another account"));
        commandManager.command(payCommand.required("target", AccountParser.accountParser()).required("amount", DoubleParser.doubleParser(0.0)).handler(ctx -> {
            if (!((BancoCommandSource)ctx.sender()).isPlayer()) {
                // empty if block
            }
            Account source = Banco.get().getAccountManager().getByName(((BancoCommandSource)ctx.sender()).name());
            Account target = (Account)ctx.get("target");
            BigDecimal amount = BigDecimal.valueOf((Double)ctx.get("amount"));
            if (target.equals(source)) {
                MessageUtil.error((Audience)ctx.sender(), "banco.commands.pay.cannot-send-money-to-yourself");
                return;
            }
            if (Banco.get().getAccountManager().amount(source).compareTo(amount) < 0) {
                MessageUtil.error((Audience)ctx.sender(), "banco.errors.not-enough-funds");
                return;
            }
            Banco.get().getAccountManager().withdraw(source, amount);
            Banco.get().getAccountManager().deposit(target, amount);
            MessageUtil.success((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.pay.success", (ComponentLike[])new ComponentLike[]{Component.text((String)MessageUtil.format(amount)), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol()), Component.text((String)Bukkit.getOfflinePlayer((UUID)target.getUuid()).getName())}));
            if (Bukkit.getOfflinePlayer((UUID)target.getUuid()).isOnline()) {
                MessageUtil.info((Audience)Bukkit.getOfflinePlayer((UUID)target.getUuid()).getPlayer(), (Component)Component.translatable((String)"banco.commands.pay.received", (ComponentLike[])new ComponentLike[]{Component.text((String)Bukkit.getOfflinePlayer((UUID)source.getUuid()).getName()), Component.text((String)MessageUtil.format(amount)), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol())}));
            }
        }));
    }
}

