/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import ovh.mythmc.banco.api.storage.BancoContainer;

public final class BundleContainerImpl
extends BancoContainer {
    @Override
    public String friendlyName() {
        return "BUNDLE";
    }

    @Override
    public Collection<ItemStack> get(UUID uuid) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return items;
        }
        items.addAll(this.getBundlesContent(player.getInventory().getContents()));
        items.addAll(this.getBundlesContent(player.getEnderChest().getContents()));
        return items;
    }

    @Override
    protected ItemStack addItem(UUID uuid, ItemStack itemStack) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || itemStack == null) {
            return itemStack;
        }
        itemStack = this.addToBundlesInContainer(player.getInventory().getContents(), itemStack);
        if (itemStack == null || itemStack.getAmount() <= 0) {
            return null;
        }
        itemStack = this.addToBundlesInContainer(player.getEnderChest().getContents(), itemStack);
        return itemStack == null || itemStack.getAmount() <= 0 ? null : itemStack;
    }

    @Override
    protected ItemStack removeItem(UUID uuid, ItemStack itemStack) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || itemStack == null) {
            return null;
        }
        itemStack = this.removeFromBundlesInContainer(player.getInventory().getContents(), itemStack);
        if (itemStack == null || itemStack.getAmount() <= 0) {
            return null;
        }
        itemStack = this.removeFromBundlesInContainer(player.getEnderChest().getContents(), itemStack);
        return itemStack == null || itemStack.getAmount() <= 0 ? null : itemStack;
    }

    private List<ItemStack> getBundlesContent(ItemStack[] container) {
        ArrayList<ItemStack> content = new ArrayList<ItemStack>();
        for (ItemStack item : container) {
            ItemStack[] itemStackArray;
            BlockStateMeta shulkerMeta;
            if (item == null || item.getType().isAir()) continue;
            if (this.isBundle(item)) {
                BundleMeta meta = (BundleMeta)item.getItemMeta();
                content.addAll(this.getItemsFromBundle(meta));
            }
            if ((shulkerMeta = this.getShulkerMeta(item)) == null || !((itemStackArray = shulkerMeta.getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox box = (ShulkerBox)itemStackArray;
            itemStackArray = box.getInventory().getContents();
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack inner = itemStackArray[i];
                if (!this.isBundle(inner)) continue;
                BundleMeta meta = (BundleMeta)inner.getItemMeta();
                content.addAll(this.getItemsFromBundle(meta));
            }
        }
        return content;
    }

    private ItemStack addToBundlesInContainer(ItemStack[] container, ItemStack itemStack) {
        for (ItemStack item : container) {
            BlockState blockState;
            if (item == null || item.getType().isAir()) continue;
            if (this.isBundle(item) && ((itemStack = this.addItemToBundleStack(item, itemStack)) == null || itemStack.getAmount() <= 0)) {
                return null;
            }
            BlockStateMeta meta = this.getShulkerMeta(item);
            if (meta == null || !((blockState = meta.getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox box = (ShulkerBox)blockState;
            Inventory inv = box.getInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack inner = inv.getItem(i);
                if (!this.isBundle(inner)) continue;
                itemStack = this.addItemToBundleStack(inner, itemStack);
                inv.setItem(i, inner);
                meta.setBlockState((BlockState)box);
                item.setItemMeta((ItemMeta)meta);
                if (itemStack != null && itemStack.getAmount() > 0) continue;
                return null;
            }
        }
        return itemStack;
    }

    private ItemStack removeFromBundlesInContainer(ItemStack[] container, ItemStack target) {
        for (ItemStack item : container) {
            BlockState blockState;
            if (item == null || item.getType().isAir()) continue;
            if (this.isBundle(item) && this.removeItemFromBundleStack(item, target)) {
                return null;
            }
            BlockStateMeta meta = this.getShulkerMeta(item);
            if (meta == null || !((blockState = meta.getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox box = (ShulkerBox)blockState;
            Inventory inv = box.getInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack inner = inv.getItem(i);
                if (!this.isBundle(inner) || !this.removeItemFromBundleStack(inner, target)) continue;
                inv.setItem(i, inner);
                meta.setBlockState((BlockState)box);
                item.setItemMeta((ItemMeta)meta);
                return null;
            }
        }
        return target;
    }

    private ItemStack addItemToBundleStack(ItemStack bundleItem, ItemStack toAdd) {
        BundleMeta meta = (BundleMeta)bundleItem.getItemMeta();
        if (meta == null) {
            return toAdd;
        }
        ItemStack result = this.addItemToBundleMeta(meta, toAdd);
        bundleItem.setItemMeta((ItemMeta)meta);
        return result;
    }

    private boolean removeItemFromBundleStack(ItemStack bundleItem, ItemStack toRemove) {
        BundleMeta meta = (BundleMeta)bundleItem.getItemMeta();
        if (meta == null) {
            return false;
        }
        boolean removed = this.removeItemFromBundleMeta(meta, toRemove);
        if (removed) {
            bundleItem.setItemMeta((ItemMeta)meta);
        }
        return removed;
    }

    private ItemStack addItemToBundleMeta(BundleMeta meta, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>(meta.getItems());
        int pending = itemStack.getAmount();
        for (ItemStack inside : contents) {
            if (!inside.isSimilar(itemStack)) continue;
            int canAdd = Math.min(inside.getMaxStackSize() - inside.getAmount(), pending);
            inside.setAmount(inside.getAmount() + canAdd);
            if ((pending -= canAdd) > 0) continue;
            break;
        }
        if (pending > 0 && this.getBundleListFreeCapacity(contents) > 0) {
            int free = Math.min(pending, this.getBundleListFreeCapacity(contents));
            ItemStack clone = itemStack.clone();
            clone.setAmount(free);
            contents.add(clone);
            pending -= free;
        }
        meta.setItems(contents.stream().filter(i -> !i.getType().isAir()).toList());
        if (pending <= 0) {
            return null;
        }
        ItemStack remainder = itemStack.clone();
        remainder.setAmount(pending);
        return remainder;
    }

    private boolean removeItemFromBundleMeta(BundleMeta meta, ItemStack target) {
        ArrayList contents = new ArrayList(meta.getItems());
        for (int i = 0; i < contents.size(); ++i) {
            ItemStack inside = (ItemStack)contents.get(i);
            if (!inside.isSimilar(target)) continue;
            int removeAmount = Math.min(inside.getAmount(), target.getAmount());
            inside.setAmount(inside.getAmount() - removeAmount);
            if (inside.getAmount() <= 0) {
                contents.remove(i);
            }
            meta.setItems(contents);
            return true;
        }
        return false;
    }

    private List<ItemStack> getItemsFromBundle(BundleMeta meta) {
        return new ArrayList<ItemStack>(meta.getItems());
    }

    private boolean isBundle(ItemStack item) {
        return item != null && item.getType().name().contains("BUNDLE");
    }

    private boolean isShulkerBox(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return item.getType().name().endsWith("SHULKER_BOX");
    }

    private BlockStateMeta getShulkerMeta(ItemStack item) {
        if (!this.isShulkerBox(item)) {
            return null;
        }
        try {
            ItemMeta meta = item.getItemMeta();
            if (!(meta instanceof BlockStateMeta)) {
                item.setItemMeta(Bukkit.getItemFactory().asMetaFor(meta, item.getType()));
                meta = item.getItemMeta();
            }
            return meta instanceof BlockStateMeta ? (BlockStateMeta)meta : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getBundleListFreeCapacity(List<ItemStack> contents) {
        int free = 64;
        for (ItemStack i : contents) {
            free -= i.getAmount();
        }
        return Math.max(free, 0);
    }
}

