/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;

public final class MessageUtil {
    public static void info(CommandSender commandSender, String message) {
        if (commandSender instanceof Audience) {
            Audience audience = (Audience)commandSender;
            MessageUtil.info(audience, message);
        }
    }

    public static void info(Audience audience, String message) {
        MessageUtil.info(audience, (Component)Component.translatable((String)message));
    }

    public static void info(Audience audience, Component message) {
        audience.sendMessage(MessageUtil.getInfoPrefix().append(message.color((TextColor)NamedTextColor.WHITE)));
    }

    public static void warn(Audience audience, String message) {
        MessageUtil.warn(audience, (Component)Component.translatable((String)message));
    }

    public static void warn(Audience audience, Component message) {
        audience.sendMessage(MessageUtil.getWarnPrefix().append(message.color((TextColor)NamedTextColor.WHITE)));
    }

    public static void success(Audience audience, String message) {
        MessageUtil.success(audience, (Component)Component.translatable((String)message));
    }

    public static void success(Audience audience, Component message) {
        audience.sendMessage(MessageUtil.getSuccessPrefix().append(message.color((TextColor)NamedTextColor.WHITE)));
    }

    public static void error(Audience audience, String message) {
        MessageUtil.error(audience, (Component)Component.translatable((String)message));
    }

    public static void error(Audience audience, Component message) {
        audience.sendMessage(MessageUtil.getErrorPrefix().append(message.color((TextColor)NamedTextColor.WHITE)));
    }

    public static void debug(Audience audience, String message) {
        MessageUtil.debug(audience, (Component)Component.translatable((String)message));
    }

    public static void debug(Audience audience, Component message) {
        audience.sendMessage(MessageUtil.getDebugPrefix().append(message.color((TextColor)NamedTextColor.WHITE)));
    }

    public static String format(@NotNull BigDecimal value) {
        DecimalFormat format = new DecimalFormat(Banco.get().getSettings().get().getCurrency().getFormat());
        return format.format(value);
    }

    private static Component getPrefix(String configPrefix) {
        TextComponent prefix = Component.empty();
        if (configPrefix != null && !configPrefix.isEmpty()) {
            prefix = MiniMessage.miniMessage().deserialize((Object)(configPrefix + " "));
        }
        return prefix;
    }

    private static Component getInfoPrefix() {
        return MessageUtil.getPrefix(Banco.get().getSettings().get().getCommands().getInfoPrefix());
    }

    private static Component getWarnPrefix() {
        return MessageUtil.getPrefix(Banco.get().getSettings().get().getCommands().getWarnPrefix());
    }

    private static Component getSuccessPrefix() {
        return MessageUtil.getPrefix(Banco.get().getSettings().get().getCommands().getSuccessPrefix());
    }

    private static Component getErrorPrefix() {
        return MessageUtil.getPrefix(Banco.get().getSettings().get().getCommands().getErrorPrefix());
    }

    private static Component getDebugPrefix() {
        return MessageUtil.getPrefix("<#2cc83c>\ud83e\udeb2</#2cc83c>");
    }

    @Generated
    private MessageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

