/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.com.j256.ormlite.logger;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.Level;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LogBackend;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LogBackendFactory;

public class CommonsLoggingLogBackend
implements LogBackend {
    private final Log log;

    public CommonsLoggingLogBackend(String className) {
        this.log = LogFactory.getLog((String)className);
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.log.isTraceEnabled();
            }
            case DEBUG: {
                return this.log.isDebugEnabled();
            }
            case WARNING: {
                return this.log.isWarnEnabled();
            }
            case ERROR: {
                return this.log.isErrorEnabled();
            }
            case FATAL: {
                return this.log.isFatalEnabled();
            }
        }
        return this.log.isInfoEnabled();
    }

    @Override
    public void log(Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.log.trace((Object)msg);
                break;
            }
            case DEBUG: {
                this.log.debug((Object)msg);
                break;
            }
            case WARNING: {
                this.log.warn((Object)msg);
                break;
            }
            case ERROR: {
                this.log.error((Object)msg);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)msg);
                break;
            }
            default: {
                this.log.info((Object)msg);
            }
        }
    }

    @Override
    public void log(Level level, String msg, Throwable t2) {
        switch (level) {
            case TRACE: {
                this.log.trace((Object)msg, t2);
                break;
            }
            case DEBUG: {
                this.log.debug((Object)msg, t2);
                break;
            }
            case WARNING: {
                this.log.warn((Object)msg, t2);
                break;
            }
            case ERROR: {
                this.log.error((Object)msg, t2);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)msg, t2);
                break;
            }
            default: {
                this.log.info((Object)msg, t2);
            }
        }
    }

    public static class CommonsLoggingLogBackendFactory
    implements LogBackendFactory {
        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new CommonsLoggingLogBackend(classLabel);
        }
    }
}

