/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.account;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.callback.account.BancoAccountRegister;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoAccountRegisterCallback {
    public static final BancoAccountRegisterCallback INSTANCE = new BancoAccountRegisterCallback();
    private final HashMap<String, BancoAccountRegisterCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoAccountRegisterCallbackListener> callbackListeners = new HashMap();

    private BancoAccountRegisterCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoAccountRegisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoAccountRegisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoAccountRegisterCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoAccountRegisterCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoAccountRegister callback, Consumer<BancoAccountRegister> result) {
        for (BancoAccountRegisterCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoAccountRegisterCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.account()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoAccountRegister callback, Consumer<BancoAccountRegister> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoAccountRegister callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoAccountRegister callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoAccountRegisterCallbackHandler {
        public void handle(BancoAccountRegister var1);
    }

    @FunctionalInterface
    public static interface BancoAccountRegisterCallbackListener {
        public void trigger(Account var1);
    }
}

