/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.item;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.callback.item.BancoItemUnregister;
import ovh.mythmc.banco.api.items.BancoItem;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoItemUnregisterCallback {
    public static final BancoItemUnregisterCallback INSTANCE = new BancoItemUnregisterCallback();
    private final HashMap<String, BancoItemUnregisterCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoItemUnregisterCallbackListener> callbackListeners = new HashMap();

    private BancoItemUnregisterCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoItemUnregisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoItemUnregisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoItemUnregisterCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoItemUnregisterCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoItemUnregister callback, Consumer<BancoItemUnregister> result) {
        for (BancoItemUnregisterCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoItemUnregisterCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.bancoItem()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoItemUnregister callback, Consumer<BancoItemUnregister> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoItemUnregister callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoItemUnregister callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoItemUnregisterCallbackHandler {
        public void handle(BancoItemUnregister var1);
    }

    @FunctionalInterface
    public static interface BancoItemUnregisterCallbackListener {
        public void trigger(BancoItem var1);
    }
}

