/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.configuration;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.configuration.sections.CommandsConfig;
import ovh.mythmc.banco.api.configuration.sections.CurrencyConfig;
import ovh.mythmc.banco.api.configuration.sections.DatabaseConfig;
import ovh.mythmc.banco.api.configuration.sections.MenusConfig;
import ovh.mythmc.banco.api.configuration.sections.UpdateCheckerConfig;
import ovh.mythmc.banco.api.scheduler.ExecutionOrder;
import ovh.mythmc.banco.libs.de.exlll.configlib.Comment;
import ovh.mythmc.banco.libs.de.exlll.configlib.Configuration;

@Configuration
public class BancoSettings {
    @Comment(value={"Enabling this will send more messages to console"})
    private boolean debug = false;
    @Comment(value={"Language that is sent when a player's locale is not available"})
    @NotNull
    private String defaultLanguageTag = "en-US";
    @Comment(value={"Delay between queued task execution in ticks (20 ticks = 1 second)"})
    private int taskQueueDelay = 2;
    @Comment(value={"Task execution type (use SYNC in small servers or switch to ASYNC in larger ones)", "Do note that ASYNC may introduce unexpected behavior"})
    private ExecutionOrder taskExecutionOrder = ExecutionOrder.SYNC;
    @Comment(value={"", "Configuration for currency"})
    private CurrencyConfig currency = new CurrencyConfig();
    @Comment(value={"", "Configuration for the database"})
    private DatabaseConfig database = new DatabaseConfig();
    @Comment(value={"", "Configuration for the update checker"})
    private UpdateCheckerConfig updateChecker = new UpdateCheckerConfig();
    @Comment(value={"", "Configuration for commands"})
    private CommandsConfig commands = new CommandsConfig();
    @Comment(value={"", "Configuration for menus/GUIs"})
    private MenusConfig menus = new MenusConfig();

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @NotNull
    @Generated
    public String getDefaultLanguageTag() {
        return this.defaultLanguageTag;
    }

    @Generated
    public int getTaskQueueDelay() {
        return this.taskQueueDelay;
    }

    @Generated
    public ExecutionOrder getTaskExecutionOrder() {
        return this.taskExecutionOrder;
    }

    @Generated
    public CurrencyConfig getCurrency() {
        return this.currency;
    }

    @Generated
    public DatabaseConfig getDatabase() {
        return this.database;
    }

    @Generated
    public UpdateCheckerConfig getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public CommandsConfig getCommands() {
        return this.commands;
    }

    @Generated
    public MenusConfig getMenus() {
        return this.menus;
    }
}

