/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.configuration.sections;

import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.items.BancoItem;
import ovh.mythmc.banco.api.items.impl.LegacyBancoItem;
import ovh.mythmc.banco.api.items.impl.VanillaBancoItem;
import ovh.mythmc.banco.libs.de.exlll.configlib.Comment;
import ovh.mythmc.banco.libs.de.exlll.configlib.Configuration;

@Configuration
public class CurrencyConfig {
    @Comment(value={"Currency name in singular"})
    @NotNull
    private String nameSingular = "Emerald";
    @Comment(value={"Currency name in plural"})
    @NotNull
    private String namePlural = "Emeralds";
    @Comment(value={"Currency symbol"})
    @NotNull
    private String symbol = "$";
    @Comment(value={"How money should be displayed (default = 1,451.34)"})
    @NotNull
    private String format = "#,###.##";
    @Comment(value={"Whether to prevent items configured below from dropping when killing mobs", "This prevents players from building money farms, so it's recommended to keep it enabled"})
    private boolean removeDrops = true;
    @Comment(value={"Order in which items will be added/removed from storages. You can add or remove entries to customize your setup"})
    private List<String> inventoryOrder = List.of("BUNDLE", "PLAYER_INVENTORY", "ENDER_CHEST", "SHULKER_BOX", "OTHER");
    @Comment(value={"Worlds where banco's economy should be disabled"})
    @NotNull
    private List<String> blacklistedWorlds = List.of("exampleWorldName");
    @Comment(value={"Allows accounts to have a negative balance"})
    private boolean negativeBalance = true;
    @Comment(value={"Configure items and their respective value", "Please, put less valuable items first. You can use MiniMessage to format text"})
    private List<BancoItem> itemRegistry = List.of(new VanillaBancoItem(Material.EMERALD, BigDecimal.valueOf(1L), null), new VanillaBancoItem(Material.EMERALD_BLOCK, BigDecimal.valueOf(9L), null), new VanillaBancoItem(Material.PLAYER_HEAD, BigDecimal.valueOf(576L), new VanillaBancoItem.BancoItemOptions("<white>Bag of Emerald Blocks</white>", List.of("<gray>Holds <white>64x Emerald Blocks</white></gray>"), 1009, false, 4, "http://textures.minecraft.net/texture/31d827a5decb0ae730abb69617776e1894f2bdb46968540433115d3688fbac38", null)));
    private List<LegacyBancoItem> items = null;

    @NotNull
    @Generated
    public String getNameSingular() {
        return this.nameSingular;
    }

    @NotNull
    @Generated
    public String getNamePlural() {
        return this.namePlural;
    }

    @NotNull
    @Generated
    public String getSymbol() {
        return this.symbol;
    }

    @NotNull
    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public boolean isRemoveDrops() {
        return this.removeDrops;
    }

    @Generated
    public List<String> getInventoryOrder() {
        return this.inventoryOrder;
    }

    @NotNull
    @Generated
    public List<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    @Generated
    public boolean isNegativeBalance() {
        return this.negativeBalance;
    }

    @Generated
    public List<BancoItem> getItemRegistry() {
        return this.itemRegistry;
    }

    @Generated
    public List<LegacyBancoItem> getItems() {
        return this.items;
    }
}

