/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.items.impl;

import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.items.BancoItem;
import ovh.mythmc.banco.libs.de.exlll.configlib.Configuration;
import ovh.mythmc.banco.libs.de.exlll.configlib.Ignore;

@Configuration
public final class VanillaBancoItem
implements BancoItem {
    private Material material;
    private BigDecimal value;
    private BancoItemOptions customization;
    @Ignore
    private ItemStack itemStack;

    VanillaBancoItem() {
    }

    public VanillaBancoItem(@NotNull Material material, @NotNull BigDecimal value, @Nullable BancoItemOptions customization) {
        this.material = material;
        this.value = value;
        this.customization = customization;
    }

    @Override
    public BigDecimal value() {
        return this.value;
    }

    @Override
    public ItemStack asItemStack(int amount) {
        if (this.itemStack != null) {
            ItemStack itemStack = this.itemStack.clone();
            itemStack.setAmount(amount);
            return itemStack;
        }
        ItemStack itemStack = new ItemStack(this.material, amount);
        if (this.customization != null) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (this.customization.displayName() != null) {
                itemMeta.setDisplayName(this.format(this.customization.displayName()));
            }
            if (this.customization.lore() != null) {
                itemMeta.setLore(this.customization.lore().stream().map(this::format).toList());
            }
            if (this.customization.customModelData() != null) {
                itemMeta.setCustomModelData(this.customization.customModelData());
            }
            if (this.customization.glowEffect() != null && this.customization.glowEffect().booleanValue()) {
                itemMeta.addEnchant(Enchantment.LOYALTY, 1, true);
            }
            if (this.customization.headTextureUrl() != null && this.material.equals((Object)Material.PLAYER_HEAD)) {
                ((SkullMeta)itemMeta).setOwnerProfile(this.getProfile(this.customization.headTextureUrl()));
            }
            if (this.customization.maxStackSize() != null) {
                itemMeta.setMaxStackSize(this.customization.maxStackSize());
            }
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemMeta.getPersistentDataContainer().set(Banco.get().getItemRegistry().CUSTOM_ITEM_IDENTIFIER_KEY, PersistentDataType.STRING, (Object)this.getIdentifier());
            if (this.customization.attributes() != null) {
                this.customization.attributes().forEach(attribute -> itemMeta.addAttributeModifier(attribute.getAttribute(), attribute.getAttributeModifier()));
            }
            itemStack.setItemMeta(itemMeta);
        }
        this.itemStack = itemStack;
        return itemStack;
    }

    private PlayerProfile getProfile(String textureUrl) {
        URL urlObject;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.nameUUIDFromBytes(textureUrl.getBytes()));
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = URI.create(textureUrl).toURL();
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }

    private String format(String input) {
        Component component = MiniMessage.miniMessage().deserialize((Object)input);
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    private String getIdentifier() {
        return String.valueOf(this.material) + "-" + String.valueOf(this.value) + "-" + String.valueOf(this.customization);
    }

    public record BancoItemOptions(String displayName, List<String> lore, Integer customModelData, Boolean glowEffect, Integer maxStackSize, String headTextureUrl, List<AttributeField> attributes) {
        private final Boolean glowEffect;

        public Boolean glowEffect() {
            if (this.glowEffect == null) {
                return false;
            }
            return this.glowEffect;
        }

        public record AttributeField(String key, double amount, AttributeModifier.Operation operation, String group) {
            public Attribute getAttribute() {
                return (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.fromString((String)this.key));
            }

            public AttributeModifier getAttributeModifier() {
                return new AttributeModifier(new NamespacedKey("banco", UUID.nameUUIDFromBytes(this.key.getBytes()).toString()), this.amount, this.operation, EquipmentSlotGroup.getByName((String)this.group));
            }
        }
    }
}

