/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.logger;

import java.lang.reflect.Array;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface LoggerWrapper {
    public static final String ARG_STRING = "{}";
    public static final int ARG_STRING_LENGTH = "{}".length();
    public static final Object UNKNOWN_ARG = new Object();

    public void info(String var1, Object ... var2);

    public void warn(String var1, Object ... var2);

    public void error(String var1, Object ... var2);

    default public String buildFullMessage(@NotNull String msg, Object ... args) {
        int argIndex;
        StringBuilder sb = null;
        int lastIndex = 0;
        int argC = 0;
        while ((argIndex = msg.indexOf(ARG_STRING, lastIndex)) != -1) {
            if (sb == null) {
                sb = new StringBuilder(128);
            }
            sb.append(msg, lastIndex, argIndex);
            lastIndex = argIndex + ARG_STRING_LENGTH;
            if (argC < args.length) {
                this.appendArg(sb, args[argC]);
            }
            ++argC;
        }
        if (sb == null) {
            return msg;
        }
        sb.append(msg, lastIndex, msg.length());
        return sb.toString();
    }

    default public void appendArg(StringBuilder stringBuilder, Object arg) {
        if (arg != UNKNOWN_ARG) {
            if (arg == null) {
                stringBuilder.append("null");
            } else if (arg.getClass().isArray()) {
                stringBuilder.append('[');
                int length = Array.getLength(arg);
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    this.appendArg(stringBuilder, Array.get(arg, i));
                }
                stringBuilder.append(']');
            } else {
                stringBuilder.append(arg);
            }
        }
    }
}

