/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.storage;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.callback.storage.BancoStorageRegister;
import ovh.mythmc.banco.api.callback.storage.BancoStorageRegisterCallback;
import ovh.mythmc.banco.api.callback.storage.BancoStorageUnregister;
import ovh.mythmc.banco.api.callback.storage.BancoStorageUnregisterCallback;
import ovh.mythmc.banco.api.storage.BancoStorage;

public final class BancoStorageRegistry {
    public static final BancoStorageRegistry instance = new BancoStorageRegistry();
    private static final Collection<BancoStorage> storages = new Vector<BancoStorage>(0);
    private BancoStorage remainderStorage = null;

    public Collection<BancoStorage> get() {
        return List.copyOf(storages);
    }

    public Collection<BancoStorage> getByOrder() {
        Collection orderedStorage = Banco.get().getSettings().get().getCurrency().getInventoryOrder().stream().map(this::getByFriendlyName).filter(o -> o != null).collect(Collectors.toList());
        if (this.remainderStorage != null) {
            orderedStorage.add(this.remainderStorage);
        }
        return orderedStorage;
    }

    public void registerStorage(BancoStorage ... bancoStorages) {
        Arrays.asList(bancoStorages).stream().forEach(storage -> {
            BancoStorageRegister callback = new BancoStorageRegister((BancoStorage)storage);
            BancoStorageRegisterCallback.INSTANCE.invoke(callback, result -> storages.add(result.bancoStorage()));
        });
    }

    public void unregisterStorage(BancoStorage ... bancoStorages) {
        Arrays.asList(bancoStorages).stream().forEach(storage -> {
            BancoStorageUnregister callback = new BancoStorageUnregister((BancoStorage)storage);
            BancoStorageUnregisterCallback.INSTANCE.invoke(callback, result -> storages.remove(result.bancoStorage()));
        });
    }

    @ApiStatus.Internal
    public void setRemainderStorage(@NotNull BancoStorage remainderStorage) {
        this.remainderStorage = remainderStorage;
    }

    public BancoStorage getByFriendlyName(@NotNull String friendlyName) {
        return storages.stream().filter(storage -> storage.friendlyName().equals(friendlyName)).findFirst().orElse(null);
    }

    @Generated
    private BancoStorageRegistry() {
    }
}

