/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.command;

import java.util.Collection;
import java.util.List;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.caption.CaptionProvider;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import ovh.mythmc.banco.common.command.BancoCaptionKeys;
import ovh.mythmc.banco.common.command.MainCommand;
import ovh.mythmc.banco.common.command.commands.BalanceChangeCommand;
import ovh.mythmc.banco.common.command.commands.BalanceCommand;
import ovh.mythmc.banco.common.command.commands.BalanceTopCommand;
import ovh.mythmc.banco.common.command.commands.BancoCommand;
import ovh.mythmc.banco.common.command.commands.PayCommand;
import ovh.mythmc.banco.common.command.sender.BancoCommandSource;

public final class BancoCommandProvider {
    private final LegacyPaperCommandManager<BancoCommandSource> commandManager;
    private final Collection<MainCommand> commands = List.of(new BalanceChangeCommand(), new BalanceCommand(), new BalanceTopCommand(), new BancoCommand(), new PayCommand());

    public BancoCommandProvider(LegacyPaperCommandManager<BancoCommandSource> commandManager) {
        this.commandManager = commandManager;
    }

    public void register() {
        this.commandManager.captionRegistry().registerProvider(CaptionProvider.constantProvider(BancoCaptionKeys.ARGUMENT_PARSE_FAILURE_ACCOUNT, "Could not find any account matching '<input>'"));
        if (this.commandManager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            this.commandManager.registerBrigadier();
        } else if (this.commandManager.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            this.commandManager.registerAsynchronousCompletions();
        }
        this.commands.forEach(command -> {
            if (command.canRegister()) {
                command.register(this.commandManager);
            }
        });
    }
}

