/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.command.commands;

import java.math.BigDecimal;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.common.command.MainCommand;
import ovh.mythmc.banco.common.command.sender.BancoCommandSource;

public final class BalanceChangeCommand
implements MainCommand {
    @Override
    public boolean canRegister() {
        return Banco.get().getSettings().get().getCommands().getBalanceChange().enabled();
    }

    @Override
    public void register(@NotNull CommandManager<BancoCommandSource> commandManager) {
        Command.Builder balanceChangeCommand = commandManager.commandBuilder("balancechange", "balchange").permission("banco.use.balancechange").commandDescription(Description.of("Compacts your balance"));
        commandManager.command(balanceChangeCommand.handler(ctx -> {
            if (!((BancoCommandSource)ctx.sender()).isPlayer()) {
                return;
            }
            Account account = Banco.get().getAccountManager().getByName(((BancoCommandSource)ctx.sender()).name());
            BigDecimal amount = account.amount();
            ((BancoCommandSource)ctx.sender()).playSound(Sound.sound((Key)Key.key((String)"item.armor.equip_iron"), (Sound.Source)Sound.Source.PLAYER, (float)0.65f, (float)1.5f));
            Banco.get().getAccountManager().withdraw(account, amount);
            Banco.get().getAccountManager().deposit(account, amount);
        }));
    }
}

