/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.hooks;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.common.util.MessageUtil;

public class BancoPlaceholderExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "banco";
    }

    @NotNull
    public String getAuthor() {
        return "U8092";
    }

    @NotNull
    public String getVersion() {
        return Banco.get().version();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        Account account = Banco.get().getAccountManager().getByUuid(player.getUniqueId());
        if (account == null) {
            return null;
        }
        if (params.equalsIgnoreCase("balance")) {
            return MessageUtil.format(account.amount());
        }
        if (params.equalsIgnoreCase("symbol")) {
            return Banco.get().getSettings().get().getCurrency().getSymbol();
        }
        if (params.equalsIgnoreCase("name_plural")) {
            return Banco.get().getSettings().get().getCurrency().getNamePlural();
        }
        if (params.equalsIgnoreCase("name_singular")) {
            return Banco.get().getSettings().get().getCurrency().getNameSingular();
        }
        if (params.equalsIgnoreCase("version")) {
            return Banco.get().version();
        }
        if (params.startsWith("top_")) {
            int pos = Integer.parseInt(params.substring(4));
            Map.Entry<UUID, BigDecimal> entry = Banco.get().getAccountManager().getTopPosition(pos);
            if (entry == null) {
                return null;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)entry.getKey());
            return offlinePlayer.getName();
        }
        return null;
    }
}

