/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.hooks;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.milkbowl.vault2.economy.AccountPermission;
import net.milkbowl.vault2.economy.Economy;
import net.milkbowl.vault2.economy.EconomyResponse;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.accounts.AccountIdentifierKey;
import ovh.mythmc.banco.common.util.MessageUtil;

public final class BancoVaultUnlockedHook
implements Economy {
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getName() {
        return "banco";
    }

    public boolean hasSharedAccountSupport() {
        return false;
    }

    public boolean hasMultiCurrencySupport() {
        return false;
    }

    @NotNull
    public int fractionalDigits(@NotNull String pluginName) {
        DecimalFormat format = new DecimalFormat(Banco.get().getSettings().get().getCurrency().getFormat());
        return format.getMaximumFractionDigits();
    }

    @NotNull
    public String format(@NotNull BigDecimal amount) {
        return this.format("banco", amount);
    }

    @NotNull
    public String format(@NotNull String pluginName, @NotNull BigDecimal amount) {
        return MessageUtil.format(amount) + Banco.get().getSettings().get().getCurrency().getSymbol();
    }

    @NotNull
    public String format(@NotNull BigDecimal amount, @NotNull String currency) {
        return this.format("banco", amount, currency);
    }

    @NotNull
    public String format(@NotNull String pluginName, @NotNull BigDecimal amount, @NotNull String currency) {
        return MessageUtil.format(amount) + Banco.get().getSettings().get().getCurrency().getSymbol();
    }

    public boolean hasCurrency(@NotNull String currency) {
        return Banco.get().getSettings().get().getCurrency().getNameSingular().equalsIgnoreCase(currency);
    }

    @NotNull
    public String getDefaultCurrency(@NotNull String pluginName) {
        return Banco.get().getSettings().get().getCurrency().getNameSingular();
    }

    @NotNull
    public String defaultCurrencyNamePlural(@NotNull String pluginName) {
        return Banco.get().getSettings().get().getCurrency().getNamePlural();
    }

    @NotNull
    public String defaultCurrencyNameSingular(@NotNull String pluginName) {
        return Banco.get().getSettings().get().getCurrency().getNameSingular();
    }

    @NotNull
    public Collection<String> currencies() {
        return List.of(Banco.get().getSettings().get().getCurrency().getNameSingular());
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name) {
        Banco.get().getAccountManager().create(accountID, name);
        return true;
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, boolean player) {
        return this.createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, @NotNull String worldName) {
        return this.createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, @NotNull String worldName, boolean player) {
        return this.createAccount(accountID, name);
    }

    @NotNull
    public Map<UUID, String> getUUIDNameMap() {
        return Banco.get().getAccountManager().getDatabase().getAccountIdentifierCache().stream().collect(Collectors.toMap(AccountIdentifierKey::uuid, AccountIdentifierKey::name));
    }

    public Optional<String> getAccountName(@NotNull UUID accountID) {
        return Optional.ofNullable(Banco.get().getAccountManager().getByUuid(accountID).getIdentifier().name());
    }

    public boolean hasAccount(@NotNull UUID accountID) {
        return Banco.get().getAccountManager().getByUuid(accountID) != null;
    }

    public boolean hasAccount(@NotNull UUID accountID, @NotNull String worldName) {
        return this.hasAccount(accountID);
    }

    public boolean renameAccount(@NotNull UUID accountID, @NotNull String name) {
        return false;
    }

    public boolean renameAccount(@NotNull String plugin, @NotNull UUID accountID, @NotNull String name) {
        return false;
    }

    public boolean deleteAccount(@NotNull String plugin, @NotNull UUID accountID) {
        Banco.get().getAccountManager().delete(accountID);
        return true;
    }

    public boolean accountSupportsCurrency(@NotNull String plugin, @NotNull UUID accountID, @NotNull String currency) {
        return this.hasAccount(accountID) && Banco.get().getSettings().get().getCurrency().getNameSingular().equalsIgnoreCase(currency);
    }

    public boolean accountSupportsCurrency(@NotNull String plugin, @NotNull UUID accountID, @NotNull String currency, @NotNull String world) {
        return this.accountSupportsCurrency(plugin, accountID, currency);
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID) {
        return Banco.get().getAccountManager().getByUuid(accountID).amount();
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world) {
        return this.getBalance(pluginName, accountID);
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world, @NotNull String currency) {
        return this.getBalance(pluginName, accountID);
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        return Banco.get().getAccountManager().has(accountID, amount);
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return this.has(pluginName, accountID, amount);
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        return this.has(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        Account account = Banco.get().getAccountManager().getByUuid(accountID);
        if (!this.has(pluginName, accountID, amount)) {
            return new EconomyResponse(amount, account.amount(), EconomyResponse.ResponseType.FAILURE, "Not enough funds");
        }
        Banco.get().getAccountManager().withdraw(accountID, amount);
        return new EconomyResponse(amount, account.amount(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @NotNull
    public EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return this.withdraw(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        return this.withdraw(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        Account account = Banco.get().getAccountManager().getByUuid(accountID);
        Banco.get().getAccountManager().deposit(accountID, amount);
        return new EconomyResponse(amount, account.amount(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @NotNull
    public EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return this.deposit(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        return this.deposit(pluginName, accountID, amount);
    }

    public boolean createSharedAccount(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String name, @NotNull UUID owner) {
        return false;
    }

    public boolean isAccountOwner(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return accountID.equals(uuid);
    }

    public boolean setOwner(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean isAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return accountID.equals(uuid);
    }

    public boolean addAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean addAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, AccountPermission ... initialPermissions) {
        return false;
    }

    public boolean removeAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean hasAccountPermission(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, @NotNull AccountPermission permission) {
        return false;
    }

    public boolean updateAccountPermission(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, @NotNull AccountPermission permission, boolean value) {
        return false;
    }
}

