/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.listeners;

import java.math.BigDecimal;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.scheduler.BancoScheduler;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        BancoScheduler.get().run(() -> {
            UUID uuid = event.getPlayer().getUniqueId();
            Account account = Banco.get().getAccountManager().getByUuid(uuid);
            if (account == null) {
                account = new Account(uuid, event.getPlayer().getName(), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
                Banco.get().getAccountManager().create(account);
            } else {
                Banco.get().getAccountManager().updateName(account, event.getPlayer().getName());
            }
            Banco.get().getAccountManager().updateTransactions(account);
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (Banco.get().getAccountManager().getByUuid(uuid) == null) {
            return;
        }
        Banco.get().getAccountManager().amount(uuid);
    }

    @Generated
    public PlayerListener() {
    }
}

