/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.menus.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.scheduler.BancoScheduler;
import ovh.mythmc.banco.common.menus.BasicMenu;
import ovh.mythmc.banco.common.menus.MenuButton;
import ovh.mythmc.banco.common.update.UpdateChecker;

public final class InfoMenu
extends BasicMenu {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)9, (String)Banco.get().getSettings().get().getMenus().getInfo().title());
    }

    @Override
    public void decorate() {
        this.addButton(0, this.getBancoButton());
        this.addButton(1, this.getInfoButton(Material.KNOWLEDGE_BOOK, "Server version", Bukkit.getBukkitVersion()));
        this.addButton(2, this.getInfoButton(Material.EMERALD, "Online mode", String.valueOf(Bukkit.getOnlineMode())));
        this.addButton(3, this.getInfoButton(Material.STICK, "Items", "" + Banco.get().getItemRegistry().get().size()));
        this.addButton(4, this.getInfoButton(Material.CHEST, "Storages", "" + Banco.get().getItemRegistry().get().size()));
        this.addButton(5, this.getInfoButton(Material.COMPASS, "Accounts", Banco.get().getAccountManager().get().size() + " (" + Banco.get().getAccountManager().getDatabase().getCachedAccounts().size() + " cached)"));
        this.addButton(6, this.getInfoButton(Material.MINECART, "Transactions in Queue", "" + BancoScheduler.get().getQueuedTransactions().size()));
        if (!UpdateChecker.getLatest().equals(Banco.get().version())) {
            this.addButton(8, this.getInfoButton(Material.BELL, "New version available", "v" + UpdateChecker.getLatest()));
        }
        super.decorate();
    }

    private MenuButton getBancoButton() {
        ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        skullMeta.setOwnerProfile(InfoMenu.getProfile("http://textures.minecraft.net/texture/198df42f477f213ff5e9d7fa5a4cc4a69f20d9cef2b90c4ae4f29bd17287b5"));
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return this.getButton(itemStack, "banco", "v" + Banco.get().version());
    }

    private MenuButton getInfoButton(Material material, String key, String value) {
        return this.getButton(new ItemStack(material), key, value);
    }

    private MenuButton getButton(ItemStack itemStack, String key, String value) {
        String name = String.format(Banco.get().getSettings().get().getMenus().getInfo().keyFormat(), key);
        String lore = String.format(Banco.get().getSettings().get().getMenus().getInfo().valueFormat(), value);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(name);
        itemMeta.setLore(List.of(lore));
        itemStack.setItemMeta(itemMeta);
        return new MenuButton(this, itemStack){

            @Override
            public void onClick(InventoryClickEvent event) {
            }
        };
    }

    private static PlayerProfile getProfile(String url) {
        URL urlObject;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = URI.create(url).toURL();
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }
}

