/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.com.j256.ormlite.field.types;

import java.sql.SQLException;
import java.util.Date;
import ovh.mythmc.banco.libs.com.j256.ormlite.field.FieldType;
import ovh.mythmc.banco.libs.com.j256.ormlite.field.SqlType;
import ovh.mythmc.banco.libs.com.j256.ormlite.field.types.BaseDateType;
import ovh.mythmc.banco.libs.com.j256.ormlite.support.DatabaseResults;

public class DateIntegerType
extends BaseDateType {
    private static final DateIntegerType singleTon = new DateIntegerType();

    public static DateIntegerType getSingleton() {
        return singleTon;
    }

    private DateIntegerType() {
        super(SqlType.INTEGER);
    }

    protected DateIntegerType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return Integer.parseInt(defaultStr);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Problems with field " + fieldType + " parsing default date-integer value: " + defaultStr, e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getInt(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        return new Date((long)((Integer)sqlArg).intValue() * 1000L);
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Date date = (Date)obj;
        return (int)(date.getTime() / 1000L);
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public Class<?> getPrimaryClass() {
        return Date.class;
    }
}

