/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.com.j256.ormlite.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import ovh.mythmc.banco.libs.com.j256.ormlite.db.DatabaseType;
import ovh.mythmc.banco.libs.com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import ovh.mythmc.banco.libs.com.j256.ormlite.jdbc.db.DatabaseTypeUtils;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.Logger;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LoggerFactory;
import ovh.mythmc.banco.libs.com.j256.ormlite.misc.IOUtils;
import ovh.mythmc.banco.libs.com.j256.ormlite.support.BaseConnectionSource;
import ovh.mythmc.banco.libs.com.j256.ormlite.support.ConnectionSource;
import ovh.mythmc.banco.libs.com.j256.ormlite.support.DatabaseConnection;

public class DataSourceConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(DataSourceConnectionSource.class);
    private DataSource dataSource;
    private DatabaseType databaseType;
    private String databaseUrl;
    private boolean initialized;
    private boolean isSingleConnection;

    public DataSourceConnectionSource() {
    }

    public DataSourceConnectionSource(DataSource dataSource, String databaseUrl) throws SQLException {
        this.dataSource = dataSource;
        this.databaseUrl = databaseUrl;
        this.initialize();
    }

    public DataSourceConnectionSource(DataSource dataSource, DatabaseType databaseType) throws SQLException {
        this.dataSource = dataSource;
        this.databaseType = databaseType;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.dataSource == null) {
            throw new IllegalStateException("dataSource was never set on " + this.getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            if (this.databaseUrl == null) {
                throw new IllegalStateException("either the databaseUri or the databaseType must be set on " + this.getClass().getSimpleName());
            }
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.databaseUrl);
        }
        this.databaseType.loadDriver();
        if (this.databaseUrl != null) {
            this.databaseType.setDriver(DriverManager.getDriver(this.databaseUrl));
        }
        JdbcDatabaseConnection jdbcConn1 = null;
        JdbcDatabaseConnection jdbcConn2 = null;
        try {
            Connection conn1 = this.dataSource.getConnection();
            Connection conn2 = this.dataSource.getConnection();
            if (conn1 == null || conn2 == null) {
                this.isSingleConnection = true;
            } else {
                jdbcConn1 = new JdbcDatabaseConnection(conn1);
                jdbcConn2 = new JdbcDatabaseConnection(conn2);
                this.isSingleConnection = this.isSingleConnection(jdbcConn1, jdbcConn2);
            }
        }
        finally {
            IOUtils.closeQuietly(jdbcConn1);
            IOUtils.closeQuietly(jdbcConn2);
        }
        this.initialized = true;
    }

    @Override
    public DatabaseConnection getReadOnlyConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.getReadWriteConnection(tableName);
    }

    public DatabaseConnection getReadOnlyConnection(String tableName, String username, String password) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.getReadWriteConnection(tableName, username, password);
    }

    @Override
    public DatabaseConnection getReadWriteConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        DatabaseConnection saved = this.getSavedConnection();
        if (saved != null) {
            return saved;
        }
        return new JdbcDatabaseConnection(this.dataSource.getConnection());
    }

    @Override
    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        if (!this.isSavedConnection(connection)) {
            IOUtils.closeThrowSqlException(connection, "SQL connection");
        }
    }

    public DatabaseConnection getReadWriteConnection(String tableName, String username, String password) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        DatabaseConnection saved = this.getSavedConnection();
        if (saved != null) {
            return saved;
        }
        return new JdbcDatabaseConnection(this.dataSource.getConnection(username, password));
    }

    @Override
    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return this.saveSpecial(connection);
    }

    @Override
    public void clearSpecialConnection(DatabaseConnection connection) {
        this.clearSpecial(connection, logger);
    }

    @Override
    public void close() throws Exception {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    @Override
    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + ".initialize() was not called");
        }
        return this.databaseType;
    }

    @Override
    public boolean isOpen(String tableName) {
        return true;
    }

    @Override
    public boolean isSingleConnection(String tableName) {
        return this.isSingleConnection;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }
}

