/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.com.j256.ormlite.logger;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.Level;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LogBackend;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LogBackendFactory;

public class Log4jLogBackend
implements LogBackend {
    private final Logger logger;

    public Log4jLogBackend(String className) {
        this.logger = Logger.getLogger((String)className);
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        return this.logger.isEnabledFor((Priority)this.levelToLog4jLevel(level));
    }

    @Override
    public void log(Level level, String msg) {
        this.logger.log((Priority)this.levelToLog4jLevel(level), (Object)msg);
    }

    @Override
    public void log(Level level, String msg, Throwable t2) {
        this.logger.log((Priority)this.levelToLog4jLevel(level), (Object)msg, t2);
    }

    private org.apache.log4j.Level levelToLog4jLevel(Level level) {
        switch (level) {
            case TRACE: {
                return org.apache.log4j.Level.TRACE;
            }
            case DEBUG: {
                return org.apache.log4j.Level.DEBUG;
            }
            case WARNING: {
                return org.apache.log4j.Level.WARN;
            }
            case ERROR: {
                return org.apache.log4j.Level.ERROR;
            }
            case FATAL: {
                return org.apache.log4j.Level.FATAL;
            }
        }
        return org.apache.log4j.Level.INFO;
    }

    public static class Log4jLogBackendFactory
    implements LogBackendFactory {
        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new Log4jLogBackend(classLabel);
        }
    }
}

