/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.de.exlll.configlib;

import java.util.function.Predicate;
import ovh.mythmc.banco.libs.de.exlll.configlib.ConfigurationElement;
import ovh.mythmc.banco.libs.de.exlll.configlib.PostProcess;
import ovh.mythmc.banco.libs.de.exlll.configlib.Validator;

public interface ConfigurationElementFilter
extends Predicate<ConfigurationElement<?>> {
    default public ConfigurationElementFilter and(Predicate<? super ConfigurationElement<?>> other) {
        return element -> this.test(element) && other.test((ConfigurationElement<?>)element);
    }

    public static ConfigurationElementFilter byType(Class<?> type) {
        Validator.requireNonNull(type, "type");
        return element -> element.type().equals(type);
    }

    public static ConfigurationElementFilter byPostProcessKey(String key) {
        Validator.requireNonNull(key, "post-process key");
        return element -> {
            PostProcess postProcess = element.annotation(PostProcess.class);
            if (postProcess == null) {
                return false;
            }
            String actualKey = postProcess.key();
            return actualKey.equals(key);
        };
    }
}

