/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.gestalt.loader;

import java.io.File;
import java.nio.file.Path;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ovh.mythmc.gestalt.loader.GestaltLoader;
import ovh.mythmc.gestalt.loader.GestaltLoggerWrapper;

public class BukkitGestaltLoader
extends GestaltLoader {
    private final Path dataDirectory;
    private final GestaltLoggerWrapper logger;

    @Override
    protected void load() {
        File file = new File(this.getGestaltPath());
        Plugin plugin = null;
        try {
            plugin = Bukkit.getPluginManager().loadPlugin(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (plugin != null) {
            Bukkit.getPluginManager().enablePlugin(plugin);
        }
    }

    @Override
    protected boolean isAvailable() {
        return Bukkit.getPluginManager().isPluginEnabled("gestalt");
    }

    @Generated
    public static BukkitGestaltLoaderBuilder builder() {
        return new BukkitGestaltLoaderBuilder();
    }

    @Generated
    private BukkitGestaltLoader(Path dataDirectory, GestaltLoggerWrapper logger) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
    }

    @Override
    @Generated
    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    @Override
    @Generated
    public GestaltLoggerWrapper getLogger() {
        return this.logger;
    }

    public static class BukkitGestaltLoaderBuilder {
        @Generated
        private Path dataDirectory;
        @Generated
        private GestaltLoggerWrapper logger;

        public BukkitGestaltLoaderBuilder initializer(JavaPlugin initializer) {
            this.dataDirectory = Path.of(initializer.getDataFolder().getParent(), new String[0]);
            this.logger = GestaltLoggerWrapper.fromLogger(initializer.getLogger(), true);
            return this;
        }

        @Generated
        BukkitGestaltLoaderBuilder() {
        }

        @Generated
        public BukkitGestaltLoaderBuilder dataDirectory(Path dataDirectory) {
            this.dataDirectory = dataDirectory;
            return this;
        }

        @Generated
        public BukkitGestaltLoaderBuilder logger(GestaltLoggerWrapper logger) {
            this.logger = logger;
            return this;
        }

        @Generated
        public BukkitGestaltLoader build() {
            return new BukkitGestaltLoader(this.dataDirectory, this.logger);
        }

        @Generated
        public String toString() {
            return "BukkitGestaltLoader.BukkitGestaltLoaderBuilder(dataDirectory=" + String.valueOf(this.dataDirectory) + ", logger=" + String.valueOf(this.logger) + ")";
        }
    }
}

