/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.gestalt.loader.util;

import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage;
import java.lang.reflect.Field;
import java.util.List;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PaperPluginClassLoaderUtil {
    private static ConfiguredPluginClassLoader getPluginClassLoaderGroup(@NotNull Plugin plugin) {
        ConfiguredPluginClassLoader configuredPluginClassLoader = null;
        PaperClassLoaderStorage instance = PaperClassLoaderStorage.instance();
        try {
            Class<?> pluginClassLoaderStorage = Class.forName("io.papermc.paper.plugin.entrypoint.classloader.group.PaperPluginClassLoaderStorage");
            Field globalGroupField = PaperPluginClassLoaderUtil.getField(pluginClassLoaderStorage, "globalGroup");
            globalGroupField.setAccessible(true);
            Object globalGroup = globalGroupField.get(instance);
            Field classloadersField = PaperPluginClassLoaderUtil.getField(globalGroup.getClass(), "classloaders");
            classloadersField.setAccessible(true);
            List classloaders = (List)classloadersField.get(globalGroup);
            for (Object o : classloaders) {
                ConfiguredPluginClassLoader classLoader;
                if (!(o instanceof ConfiguredPluginClassLoader) || !(classLoader = (ConfiguredPluginClassLoader)o).getConfiguration().getName().equals(plugin.getDescription().getName())) continue;
                configuredPluginClassLoader = classLoader;
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        return configuredPluginClassLoader;
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return PaperPluginClassLoaderUtil.getField(superClass, fieldName);
        }
    }

    public static void mergeClassLoaders(@NotNull Plugin pluginToMerge, @NotNull Plugin destination) {
        PaperPluginClassLoaderUtil.getPluginClassLoaderGroup(destination).getGroup().add(PaperPluginClassLoaderUtil.getPluginClassLoaderGroup(pluginToMerge));
    }

    public static boolean isAccessible(@NotNull Plugin plugin, @NotNull String className) {
        try {
            PaperPluginClassLoaderUtil.getPluginClassLoaderGroup(plugin).loadClass(className, false, true, true);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Generated
    private PaperPluginClassLoaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

