/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.accounts;

import java.math.BigDecimal;
import java.util.UUID;
import lombok.Generated;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.AccountIdentifierKey;
import ovh.mythmc.banco.libs.com.j256.ormlite.field.DatabaseField;
import ovh.mythmc.banco.libs.com.j256.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="accounts")
public class Account {
    @DatabaseField(id=true)
    private UUID uuid;
    @DatabaseField
    private String name;
    @DatabaseField(defaultValue="0.0")
    private BigDecimal amount;
    @DatabaseField(defaultValue="0.0")
    private BigDecimal transactions;

    public BigDecimal amount() {
        return Banco.get().getAccountManager().amount(this.uuid);
    }

    public AccountIdentifierKey getIdentifier() {
        return AccountIdentifierKey.of(this.uuid, this.name);
    }

    protected void setAmount(BigDecimal amount) {
        this.amount = BigDecimal.valueOf(0L).max(amount);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$transactions = this.getTransactions();
        BigDecimal other$transactions = other.getTransactions();
        return !(this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Account(uuid=" + String.valueOf(this.getUuid()) + ", name=" + this.getName() + ", amount=" + String.valueOf(this.getAmount()) + ", transactions=" + String.valueOf(this.getTransactions()) + ")";
    }

    @Generated
    protected BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    protected BigDecimal getTransactions() {
        return this.transactions;
    }

    @Generated
    protected void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    protected void setName(String name) {
        this.name = name;
    }

    @Generated
    protected void setTransactions(BigDecimal transactions) {
        this.transactions = transactions;
    }

    @Generated
    public Account(UUID uuid, String name, BigDecimal amount, BigDecimal transactions) {
        this.uuid = uuid;
        this.name = name;
        this.amount = amount;
        this.transactions = transactions;
    }

    @Generated
    Account() {
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

