/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.accounts;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.callback.transaction.BancoTransactionProcess;
import ovh.mythmc.banco.api.callback.transaction.BancoTransactionProcessCallback;
import ovh.mythmc.banco.api.scheduler.BancoScheduler;
import ovh.mythmc.banco.api.storage.BancoStorage;

public class Transaction {
    @NotNull
    private Account account;
    @NotNull
    private Operation operation;
    @NotNull
    private BigDecimal amount;
    private boolean loggable;

    public void transact() {
        BancoTransactionProcess callback = new BancoTransactionProcess(this);
        BancoTransactionProcessCallback.INSTANCE.invoke(callback);
        if (callback.cancelled()) {
            return;
        }
        switch (this.operation.ordinal()) {
            case 0: {
                this.set(this.account.amount().add(this.amount));
                break;
            }
            case 1: {
                this.set(this.account.amount().subtract(this.amount));
                break;
            }
            case 2: {
                this.set(this.amount);
            }
        }
        if (this.loggable) {
            Banco.get().getAccountManager().getTransactionHistory().register(this.account.getIdentifier(), this);
        }
    }

    public void queue() {
        BancoScheduler.get().queueTransaction(this);
    }

    public ImmutableView asImmutable() {
        return new ImmutableView(this);
    }

    private void set(@NotNull BigDecimal newAmount) {
        if (this.account.amount().compareTo(newAmount) == 0) {
            return;
        }
        if (this.account.amount().compareTo(newAmount) < 0) {
            this.account.setTransactions(BigDecimal.valueOf(0L));
            BigDecimal toAdd = newAmount.subtract(this.account.amount());
            if (Bukkit.getOfflinePlayer((UUID)this.account.getUuid()).isOnline()) {
                for (BancoStorage storage : Banco.get().getStorageRegistry().getByOrder()) {
                    if (toAdd.compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                    toAdd = toAdd.subtract(storage.add(this.account.getUuid(), toAdd));
                }
                this.account.setTransactions(this.account.getTransactions().add(toAdd.setScale(2, RoundingMode.HALF_UP)));
                Banco.get().getAccountManager().getDatabase().updateCache(this.account);
                return;
            }
            for (BancoStorage storage : Banco.get().getStorageRegistry().getByOrder()) {
                if (!storage.supportsOfflinePlayers() || toAdd.compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                toAdd = toAdd.subtract(storage.add(this.account.getUuid(), toAdd));
            }
            this.account.setTransactions(this.account.getTransactions().add(toAdd));
            Banco.get().getAccountManager().getDatabase().updateCache(this.account);
        } else {
            BigDecimal toRemove = this.account.amount().subtract(newAmount);
            if (Bukkit.getOfflinePlayer((UUID)this.account.getUuid()).isOnline()) {
                for (BancoStorage storage : Banco.get().getStorageRegistry().getByOrder()) {
                    if (toRemove.compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                    toRemove = storage.remove(this.account.getUuid(), toRemove);
                }
                this.account.setTransactions(this.account.getTransactions().subtract(toRemove.setScale(2, RoundingMode.HALF_UP)));
                Banco.get().getAccountManager().getDatabase().updateCache(this.account);
                return;
            }
            for (BancoStorage storage : Banco.get().getStorageRegistry().getByOrder()) {
                if (!storage.supportsOfflinePlayers() || toRemove.compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                toRemove = storage.remove(this.account.getUuid(), toRemove);
            }
            this.account.setTransactions(this.account.getTransactions().subtract(toRemove));
            Banco.get().getAccountManager().getDatabase().updateCache(this.account);
        }
    }

    @Generated
    private static boolean $default$loggable() {
        return true;
    }

    @Generated
    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    @NotNull
    @Generated
    public Account account() {
        return this.account;
    }

    @NotNull
    @Generated
    public Operation operation() {
        return this.operation;
    }

    @NotNull
    @Generated
    public BigDecimal amount() {
        return this.amount;
    }

    @Generated
    public boolean loggable() {
        return this.loggable;
    }

    @Generated
    public Transaction account(@NotNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.account = account;
        return this;
    }

    @Generated
    public Transaction operation(@NotNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.operation = operation;
        return this;
    }

    @Generated
    public Transaction amount(@NotNull BigDecimal amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
        return this;
    }

    @Generated
    public Transaction loggable(boolean loggable) {
        this.loggable = loggable;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.loggable() != other.loggable()) {
            return false;
        }
        Account this$account = this.account();
        Account other$account = other.account();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        Operation this$operation = this.operation();
        Operation other$operation = other.operation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        BigDecimal this$amount = this.amount();
        BigDecimal other$amount = other.amount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.loggable() ? 79 : 97);
        Account $account = this.account();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        Operation $operation = this.operation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        BigDecimal $amount = this.amount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Transaction(account=" + String.valueOf(this.account()) + ", operation=" + String.valueOf((Object)this.operation()) + ", amount=" + String.valueOf(this.amount()) + ", loggable=" + this.loggable() + ")";
    }

    @Generated
    public Transaction(@NotNull Account account, @NotNull Operation operation, @NotNull BigDecimal amount, boolean loggable) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.account = account;
        this.operation = operation;
        this.amount = amount;
        this.loggable = loggable;
    }

    public static enum Operation {
        DEPOSIT,
        WITHDRAW,
        SET;

    }

    public static class ImmutableView {
        private final Transaction transaction;
        private final Instant timestamp;

        ImmutableView(Transaction transaction) {
            this.transaction = transaction;
            this.timestamp = Instant.now();
        }

        public Account account() {
            return this.transaction.account;
        }

        public BigDecimal amount() {
            return this.transaction.amount;
        }

        public Operation operation() {
            return this.transaction.operation;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    @Generated
    public static class TransactionBuilder {
        @Generated
        private Account account;
        @Generated
        private Operation operation;
        @Generated
        private BigDecimal amount;
        @Generated
        private boolean loggable$set;
        @Generated
        private boolean loggable$value;

        @Generated
        TransactionBuilder() {
        }

        @Generated
        public TransactionBuilder account(@NotNull Account account) {
            if (account == null) {
                throw new NullPointerException("account is marked non-null but is null");
            }
            this.account = account;
            return this;
        }

        @Generated
        public TransactionBuilder operation(@NotNull Operation operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            this.operation = operation;
            return this;
        }

        @Generated
        public TransactionBuilder amount(@NotNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @Generated
        public TransactionBuilder loggable(boolean loggable) {
            this.loggable$value = loggable;
            this.loggable$set = true;
            return this;
        }

        @Generated
        public Transaction build() {
            boolean loggable$value = this.loggable$value;
            if (!this.loggable$set) {
                loggable$value = Transaction.$default$loggable();
            }
            return new Transaction(this.account, this.operation, this.amount, loggable$value);
        }

        @Generated
        public String toString() {
            return "Transaction.TransactionBuilder(account=" + String.valueOf(this.account) + ", operation=" + String.valueOf((Object)this.operation) + ", amount=" + String.valueOf(this.amount) + ", loggable$value=" + this.loggable$value + ")";
        }
    }
}

