/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.boot;

import java.io.File;
import java.util.Arrays;
import lombok.Generated;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.BancoSupplier;
import ovh.mythmc.banco.api.configuration.BancoSettingsProvider;
import ovh.mythmc.banco.api.scheduler.BancoScheduler;
import ovh.mythmc.banco.common.command.BancoCommandProvider;
import ovh.mythmc.banco.common.features.InventoryFeatures;
import ovh.mythmc.banco.common.features.ItemFeatures;
import ovh.mythmc.banco.common.features.LocalizationFeature;
import ovh.mythmc.banco.common.features.MetricsFeature;
import ovh.mythmc.banco.common.features.PlaceholderAPIFeature;
import ovh.mythmc.banco.common.features.UpdateCheckerFeature;
import ovh.mythmc.banco.common.features.VaultFeature;
import ovh.mythmc.banco.common.listeners.BancoListener;
import ovh.mythmc.banco.common.listeners.GestaltListener;
import ovh.mythmc.banco.common.menu.MenuDispatcher;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.Level;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.Logger;
import ovh.mythmc.gestalt.Gestalt;
import ovh.mythmc.gestalt.features.FeatureConstructorParams;
import ovh.mythmc.gestalt.features.GestaltFeature;

public abstract class BancoBootstrap
implements Banco {
    private JavaPlugin plugin;
    private final BancoSettingsProvider settings;
    private final File dataDirectory;
    private final BancoCommandProvider commandProvider;
    private BancoListener bancoListener;
    private volatile boolean shuttingDown = false;

    public BancoBootstrap(@NotNull JavaPlugin plugin, @NotNull File dataDirectory, @NotNull BancoCommandProvider commandProvider) {
        BancoSupplier.set(this);
        this.plugin = plugin;
        this.dataDirectory = dataDirectory;
        this.settings = new BancoSettingsProvider(dataDirectory);
        this.commandProvider = commandProvider;
    }

    public final void initialize() {
        BancoScheduler.set(this.scheduler());
        this.loadGestalt();
        Gestalt.get().register(new Class[]{InventoryFeatures.class, ItemFeatures.class, PlaceholderAPIFeature.class, UpdateCheckerFeature.class});
        this.registerFeatureWithPluginParam(LocalizationFeature.class, MetricsFeature.class, VaultFeature.class);
        this.reload();
        if (this.getSettings().get().getDatabase().isAsynchronousWrites()) {
            this.getLogger().warn("Asynchronous saving is enabled. This feature is experimental and may cause data loss or unexpected behavior. Use at your own risk.", new Object[0]);
            this.getLogger().warn("You can disable this option by setting 'asynchronousWrites' to 'false' in the plugin's settings.yml file.", new Object[0]);
        }
        Gestalt.get().getListenerRegistry().register((Object)new GestaltListener(), true);
        this.bancoListener = new BancoListener();
        this.bancoListener.registerCallbacks();
        try {
            Logger.setGlobalLogLevel(Level.ERROR);
            Banco.get().getAccountManager().getDatabase().initialize(this.dataDirectory.getAbsolutePath() + File.separator + "accounts.db");
            this.enable();
            this.commandProvider.register();
        }
        catch (Throwable throwable) {
            this.getLogger().error("An error has occurred while initializing banco: {}", throwable);
            throwable.printStackTrace(System.err);
            return;
        }
    }

    public abstract void loadGestalt();

    public abstract void enable();

    public abstract void disable();

    public final void shutdown() {
        this.shuttingDown = true;
        this.bancoListener.unregisterCallbacks();
        Banco.get().getAccountManager().getDatabase().shutdown();
    }

    @Override
    public final void reload() {
        Gestalt.get().disableAllFeatures("banco");
        this.getSettings().load();
        Gestalt.get().enableAllFeatures("banco");
    }

    @Override
    public final boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public abstract String version();

    public abstract BancoScheduler scheduler();

    public abstract MenuDispatcher menuDispatcher();

    private void registerFeatureWithPluginParam(Class<?> ... classes) {
        Arrays.stream(classes).forEach(clazz -> Gestalt.get().register(GestaltFeature.builder().featureClass(clazz).constructorParams(FeatureConstructorParams.builder().params(new Object[]{this.plugin}).types(new Class[]{JavaPlugin.class}).build()).build()));
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @Generated
    public BancoSettingsProvider getSettings() {
        return this.settings;
    }

    @Generated
    public File getDataDirectory() {
        return this.dataDirectory;
    }

    @Generated
    public BancoCommandProvider getCommandProvider() {
        return this.commandProvider;
    }

    @Generated
    public BancoListener getBancoListener() {
        return this.bancoListener;
    }

    @Generated
    public BancoBootstrap(BancoSettingsProvider settings, File dataDirectory, BancoCommandProvider commandProvider) {
        this.settings = settings;
        this.dataDirectory = dataDirectory;
        this.commandProvider = commandProvider;
    }
}

