/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.com.j256.ormlite.logger;

import ovh.mythmc.banco.libs.com.j256.ormlite.logger.ConsoleLogBackend;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.Level;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LocalLogBackend;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LogBackend;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.LogBackendFactory;
import ovh.mythmc.banco.libs.com.j256.ormlite.logger.NullLogBackend;

public enum LogBackendType implements LogBackendFactory
{
    SLF4J("ovh.mythmc.banco.libs.com.j256.ormlite.logger.Slf4jLoggingLogBackend$Slf4jLoggingLogBackendFactory"),
    ANDROID("ovh.mythmc.banco.libs.com.j256.ormlite.android.AndroidLogBackend$AndroidLogBackendFactory"),
    LOGBACK("ovh.mythmc.banco.libs.com.j256.ormlite.logger.LogbackLogBackend$LogbackLogBackendFactory"),
    COMMONS_LOGGING("ovh.mythmc.banco.libs.com.j256.ormlite.logger.CommonsLoggingLogBackend$CommonsLoggingLogBackendFactory"),
    LOG4J2("ovh.mythmc.banco.libs.com.j256.ormlite.logger.Log4j2LogBackend$Log4j2LogBackendFactory"),
    LOG4J("ovh.mythmc.banco.libs.com.j256.ormlite.logger.Log4jLogBackend$Log4jLogBackendFactory"),
    LOCAL(new LocalLogBackend.LocalLogBackendFactory()),
    CONSOLE(new ConsoleLogBackend.ConsoleLogBackendFactory()),
    JAVA_UTIL("ovh.mythmc.banco.libs.com.j256.ormlite.logger.JavaUtilLogBackend$JavaUtilLogBackendFactory"),
    NULL(new NullLogBackend.NullLogBackendFactory());

    private final LogBackendFactory factory;

    private LogBackendType(LogBackendFactory factory) {
        this.factory = factory;
    }

    private LogBackendType(String logBackendFactoryClassName) {
        this.factory = this.detectFactory(logBackendFactoryClassName);
    }

    @Override
    public LogBackend createLogBackend(String classLabel) {
        return this.factory.createLogBackend(classLabel);
    }

    public boolean isAvailable() {
        return this == LOCAL || this != NULL && !(this.factory instanceof LocalLogBackend.LocalLogBackendFactory);
    }

    private LogBackendFactory detectFactory(String factoryClassName) {
        try {
            LogBackendFactory factory = (LogBackendFactory)Class.forName(factoryClassName).newInstance();
            factory.createLogBackend("test").isLevelEnabled(Level.INFO);
            return factory;
        }
        catch (Throwable th) {
            String queuedWarning = "Unable to create instance of class " + factoryClassName + " for log type " + this + ", using local log: " + th.getMessage();
            return new LocalLogBackend.LocalLogBackendFactory(queuedWarning);
        }
    }
}

