/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.gestalt.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import ovh.mythmc.gestalt.Gestalt;
import ovh.mythmc.gestalt.loader.GestaltLoggerWrapper;

public abstract class GestaltLoader {
    protected abstract Path getDataDirectory();

    protected abstract GestaltLoggerWrapper getLogger();

    protected abstract boolean isAvailable();

    public void initialize() {
        if (this.isAvailable()) {
            return;
        }
        this.setupGestaltPath();
        boolean load = true;
        if (!Files.exists(Path.of(this.getGestaltPath(), new String[0]), new LinkOption[0])) {
            load = this.downloadGestalt();
        }
        if (load) {
            this.load();
        }
    }

    protected abstract void load();

    public void terminate() {
        if (!Gestalt.get().isAutoUpdate()) {
            return;
        }
        try {
            URLClassLoader loader = (URLClassLoader)Gestalt.get().getClass().getClassLoader();
            loader.close();
            Files.deleteIfExists(Path.of(this.getGestaltPath(), new String[0]));
        }
        catch (Throwable t2) {
            this.getLogger().error("Error while terminating the instance!");
            t2.printStackTrace(System.err);
        }
    }

    protected String getGestaltPath() {
        return String.valueOf(this.getDataDirectory()) + File.separator + "libs" + File.separator + "gestalt.jar";
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("gestalt.properties"));
        }
        catch (IOException e) {
            this.getLogger().error("Gestalt properties file not accessible! (shaded?)");
            e.printStackTrace(System.err);
        }
        return properties;
    }

    private void setupGestaltPath() {
        try {
            Files.createDirectories(Path.of(this.getGestaltPath(), new String[0]).getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.getLogger().error("Gestalt path cannot be created! (permission issue?)");
            e.printStackTrace(System.err);
        }
    }

    private boolean downloadGestalt() {
        boolean downloaded = false;
        this.getLogger().verbose("Downloading gestalt (event-based library for managing features)...");
        for (int i = 1; i <= 10; ++i) {
            String key = "server." + i;
            String url = this.getProperties().getProperty(key);
            if (url == null) continue;
            try {
                long bytes = GestaltLoader.download(url, this.getGestaltPath());
                this.getLogger().verbose("Downloaded " + bytes / 1000L + " KBs from server " + i);
                downloaded = true;
                break;
            }
            catch (IOException e) {
                this.getLogger().error("Couldn't fetch gestalt! (server down? / switch DNS servers?)");
                this.getLogger().info("Retrying with server " + (i + 1) + "...");
            }
        }
        return downloaded;
    }

    private static long download(String url, String fileName) throws IOException {
        try (InputStream in = URI.create(url).toURL().openStream();){
            long l = Files.copy(in, Paths.get(fileName, new String[0]), new CopyOption[0]);
            return l;
        }
    }
}

