/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.items.impl;

import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.items.BancoItem;

public record LegacyBancoItem(@NotNull String name, String displayName, List<String> lore, Integer customModelData, Boolean glowEffect, @NotNull BigDecimal value) implements BancoItem
{
    @Override
    public ItemStack asItemStack(int amount) {
        ItemStack itemStack = new ItemStack(Material.valueOf((String)this.name), amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (this.displayName != null) {
            itemMeta.setDisplayName(this.displayName);
        }
        if (this.lore != null) {
            itemMeta.setLore(this.lore.stream().toList());
        }
        if (this.customModelData != null) {
            itemMeta.setCustomModelData(this.customModelData);
        }
        if (this.glowEffect != null && this.glowEffect.booleanValue()) {
            itemMeta.addEnchant(Enchantment.LOYALTY, 1, true);
        }
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Generated
    LegacyBancoItem withName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new LegacyBancoItem(name, this.displayName, this.lore, this.customModelData, this.glowEffect, this.value);
    }

    @Generated
    LegacyBancoItem withDisplayName(String displayName) {
        return this.displayName == displayName ? this : new LegacyBancoItem(this.name, displayName, this.lore, this.customModelData, this.glowEffect, this.value);
    }

    @Generated
    LegacyBancoItem withLore(List<String> lore) {
        return this.lore == lore ? this : new LegacyBancoItem(this.name, this.displayName, lore, this.customModelData, this.glowEffect, this.value);
    }

    @Generated
    LegacyBancoItem withCustomModelData(Integer customModelData) {
        return this.customModelData == customModelData ? this : new LegacyBancoItem(this.name, this.displayName, this.lore, customModelData, this.glowEffect, this.value);
    }

    @Generated
    LegacyBancoItem withGlowEffect(Boolean glowEffect) {
        return this.glowEffect == glowEffect ? this : new LegacyBancoItem(this.name, this.displayName, this.lore, this.customModelData, glowEffect, this.value);
    }

    @Generated
    LegacyBancoItem withValue(@NotNull BigDecimal value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.value == value ? this : new LegacyBancoItem(this.name, this.displayName, this.lore, this.customModelData, this.glowEffect, value);
    }
}

