/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.storage;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.items.BancoItem;
import ovh.mythmc.banco.api.storage.BancoStorage;
import ovh.mythmc.banco.api.util.ItemUtil;

public abstract class BancoContainer
implements BancoStorage {
    protected abstract Collection<ItemStack> get(UUID var1);

    protected abstract ItemStack addItem(UUID var1, ItemStack var2);

    protected abstract ItemStack removeItem(UUID var1, ItemStack var2);

    @Override
    @NotNull
    public BigDecimal value(UUID uuid) {
        BigDecimal value = BigDecimal.valueOf(0L);
        for (ItemStack item : this.get(uuid)) {
            BancoItem bancoItem;
            if (item == null || (bancoItem = Banco.get().getItemRegistry().getByItemStack(item)) == null) continue;
            value = value.add(bancoItem.value(item.getAmount()));
        }
        return value;
    }

    @Override
    @NotNull
    public BigDecimal add(UUID uuid, BigDecimal amount) {
        BigDecimal amountGiven = BigDecimal.valueOf(0L);
        for (ItemStack itemStack : ItemUtil.convertAmountToItems(amount)) {
            BancoItem remainderBancoItem;
            BancoItem bancoItem = Banco.get().getItemRegistry().getByItemStack(itemStack);
            amountGiven = amountGiven.add(bancoItem.value(itemStack.getAmount()));
            ItemStack remainderItemStack = this.addItem(uuid, itemStack);
            if (remainderItemStack == null || (remainderBancoItem = Banco.get().getItemRegistry().getByItemStack(remainderItemStack)) == null) continue;
            amountGiven = amountGiven.subtract(remainderBancoItem.value(remainderItemStack.getAmount()));
        }
        return amountGiven;
    }

    @Override
    @NotNull
    public BigDecimal remove(UUID uuid, BigDecimal amount) {
        for (BancoItem bancoItem : Banco.get().getItemRegistry().get()) {
            for (ItemStack item : this.get(uuid)) {
                BigDecimal value;
                if (item == null || !Objects.equals(Banco.get().getItemRegistry().getByItemStack(item), bancoItem) || amount.compareTo(BigDecimal.valueOf(0.01)) < 0 || (value = bancoItem.value(item.getAmount())).compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                this.removeItem(uuid, item);
                BigDecimal removed = BigDecimal.valueOf(0L);
                if (value.compareTo(amount) > 0) {
                    removed = value.subtract(amount);
                    Banco.get().getAccountManager().deposit(uuid, removed);
                }
                amount = amount.subtract(value.subtract(removed));
            }
        }
        return amount;
    }
}

