/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.menus.impl;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.service.OfflinePlayerReference;
import ovh.mythmc.banco.common.menus.BasicMenu;
import ovh.mythmc.banco.common.menus.MenuButton;
import ovh.mythmc.banco.common.util.MessageUtil;

public final class BalanceTopMenu
extends BasicMenu {
    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)9, (String)Banco.get().getSettings().get().getMenus().getBalanceTop().title());
    }

    @Override
    public void decorate() {
        Banco.get().getAccountManager().getTopAsync(1024000).thenAccept(map -> {
            int slot = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (slot >= 8) break;
                Optional<OfflinePlayerReference> optPlayerReference = Banco.get().getAccountManager().getUuidResolver().resolveOfflinePlayer((UUID)entry.getKey());
                if (optPlayerReference.isEmpty() || !optPlayerReference.get().toOfflinePlayer().hasPlayedBefore()) continue;
                OfflinePlayer player = optPlayerReference.get().toOfflinePlayer();
                String balance = MessageUtil.format((BigDecimal)entry.getValue()) + Banco.get().getSettings().get().getCurrency().getSymbol();
                String itemName = String.format(Banco.get().getSettings().get().getMenus().getBalanceTop().format(), slot + 1, player.getName(), balance);
                ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                skullMeta.setOwningPlayer(player);
                skullMeta.setDisplayName(itemName);
                itemStack.setItemMeta((ItemMeta)skullMeta);
                MenuButton button = new MenuButton(this, itemStack){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                    }
                };
                this.addButton(slot, button);
                ++slot;
            }
            super.decorate();
            this.update();
        });
    }
}

