/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.accounts.service;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.service.LocalUUIDResolver;
import ovh.mythmc.banco.api.accounts.service.OfflinePlayerReference;
import ovh.mythmc.banco.api.scheduler.BancoScheduler;

public abstract class AbstractLocalUUIDResolver
implements LocalUUIDResolver {
    private final Set<OfflinePlayerReference> offlinePlayers = ConcurrentHashMap.newKeySet();

    protected abstract Iterable<OfflinePlayerReference> serverOfflinePlayers();

    protected AbstractLocalUUIDResolver(@NotNull BancoScheduler scheduler) {
        scheduler.run(() -> scheduler.runAsync(() -> {
            this.serverOfflinePlayers().forEach(this.offlinePlayers::add);
            Banco.get().getLogger().info("Cached {} offline players!", this.offlinePlayers.size());
        }));
    }

    @Override
    public Set<OfflinePlayerReference> references() {
        return this.offlinePlayers;
    }

    @Override
    @NotNull
    public Optional<UUID> resolve(@NotNull String username) {
        return Set.copyOf(this.offlinePlayers).stream().filter(offlinePlayer -> offlinePlayer.name().equals(username)).map(OfflinePlayerReference::uuid).findAny();
    }

    @Override
    @NotNull
    public Optional<OfflinePlayerReference> resolveOfflinePlayer(@NotNull UUID uuid) {
        return Set.copyOf(this.offlinePlayers).stream().filter(offlinePlayer -> offlinePlayer.uuid().equals(uuid)).findAny();
    }

    protected boolean add(@NotNull OfflinePlayerReference offlinePlayer) {
        return this.offlinePlayers.add(offlinePlayer);
    }

    protected boolean remove(@NotNull UUID uuid) {
        return this.offlinePlayers.removeIf(offlinePlayer -> offlinePlayer.uuid().equals(uuid));
    }

    protected boolean remove(@NotNull OfflinePlayerReference offlinePlayer) {
        return this.remove(offlinePlayer.uuid());
    }

    protected boolean has(@NotNull UUID uuid) {
        return this.offlinePlayers.stream().anyMatch(offlinePlayer -> offlinePlayer.uuid().equals(uuid));
    }

    protected boolean has(@NotNull OfflinePlayerReference offlinePlayer) {
        return this.has(offlinePlayer.uuid());
    }

    protected boolean update(@NotNull OfflinePlayerReference offlinePlayer) {
        if (this.has(offlinePlayer)) {
            this.remove(offlinePlayer);
        }
        return this.add(offlinePlayer);
    }
}

