/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.items.impl;

import java.io.IOException;
import java.math.BigDecimal;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.items.BancoItem;
import ovh.mythmc.banco.api.util.ItemUtil;
import ovh.mythmc.banco.libs.de.exlll.configlib.Configuration;
import ovh.mythmc.banco.libs.de.exlll.configlib.Ignore;

@Configuration
public final class Base64BancoItem
implements BancoItem {
    @Ignore
    private ItemStack itemStack;
    private String string;
    private BigDecimal value;

    public Base64BancoItem(@NotNull String string, @NotNull BigDecimal value) {
        this.itemStack = Base64BancoItem.encode(string);
        this.string = string;
        this.value = value;
    }

    Base64BancoItem() {
    }

    @Override
    public ItemStack asItemStack(int amount) {
        if (this.itemStack == null) {
            this.itemStack = Base64BancoItem.encode(this.string);
        }
        ItemStack item = this.itemStack.clone();
        item.setAmount(amount);
        return item;
    }

    @Override
    public BigDecimal value() {
        return this.value;
    }

    private static ItemStack encode(@NotNull String string) {
        try {
            return ItemUtil.fromBase64(string);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

