/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.items.BancoItem;

public final class ItemUtil {
    public static List<ItemStack> convertAmountToItems(BigDecimal amount) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (BancoItem bancoItem : Banco.get().getItemRegistry().get().reversed()) {
            do {
                int itemAmount;
                if ((itemAmount = Math.min(amount.divide(bancoItem.value(), RoundingMode.FLOOR).intValue(), bancoItem.asItemStack().getMaxStackSize())) <= 0) continue;
                items.add(bancoItem.asItemStack(itemAmount));
                amount = amount.subtract(bancoItem.value(itemAmount));
            } while (bancoItem.value().compareTo(amount) < 0);
        }
        return items;
    }

    public static String toBase64(ItemStack itemStack) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
        dataOutput.writeObject((Object)itemStack);
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static ItemStack fromBase64(@NotNull String base64String) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64String));
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
        return (ItemStack)dataInput.readObject();
    }
}

