/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.command.commands;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.MinecraftHelp;
import org.incendo.cloud.parser.flag.CommandFlag;
import org.incendo.cloud.parser.standard.DoubleParser;
import org.incendo.cloud.parser.standard.StringParser;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.scheduler.BancoScheduler;
import ovh.mythmc.banco.api.util.ItemUtil;
import ovh.mythmc.banco.common.boot.BancoBootstrap;
import ovh.mythmc.banco.common.command.MainCommand;
import ovh.mythmc.banco.common.command.parser.AccountParser;
import ovh.mythmc.banco.common.command.sender.BancoCommandSource;
import ovh.mythmc.banco.common.update.UpdateChecker;
import ovh.mythmc.banco.common.util.MessageUtil;

public final class BancoCommand
implements MainCommand {
    private MinecraftHelp<BancoCommandSource> help;

    @Override
    public boolean canRegister() {
        return true;
    }

    @Override
    public void register(@NotNull CommandManager<BancoCommandSource> commandManager) {
        this.help = MinecraftHelp.createNative("/banco help", commandManager);
        Command.Builder bancoCommand = commandManager.commandBuilder("banco", new String[0]).commandDescription(Description.of("Main command for managing accounts"));
        commandManager.command(bancoCommand.literal("help", "?").permission("banco.use.banco.help").commandDescription(Description.of("Displays the plugin's command structure")).optional("query", StringParser.greedyStringParser(), DefaultValue.constant("")).handler(ctx -> this.help.queryCommands((String)ctx.get("query"), (BancoCommandSource)ctx.sender())));
        commandManager.command(bancoCommand.literal("encode", "base64").permission("banco.use.banco.encode").commandDescription(Description.of("Encodes the item in your main hand into a Base64 string")).handler(ctx -> {
            if (!((BancoCommandSource)ctx.sender()).isPlayer()) {
                return;
            }
            Player player = (Player)((BancoCommandSource)ctx.sender()).source();
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            try {
                String encodedString = ItemUtil.toBase64(itemStack);
                MessageUtil.success((Audience)ctx.sender(), ((TranslatableComponent)Component.translatable((String)"banco.commands.encode.success", (ComponentLike[])new ComponentLike[]{Component.text((String)(encodedString.substring(0, 16) + "..."), (TextColor)NamedTextColor.GRAY)}).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.translatable((String)"banco.commands.encode.hover")))).clickEvent(ClickEvent.copyToClipboard((String)encodedString)));
            }
            catch (IOException e) {
                MessageUtil.error((Audience)ctx.sender(), (Component)Component.text((String)e.getMessage(), (TextColor)NamedTextColor.RED));
            }
        }));
        commandManager.command(bancoCommand.literal("give", new String[0]).permission("banco.use.banco.give").commandDescription(Description.of("Adds funds to an account")).required("target", AccountParser.accountParser()).required("amount", DoubleParser.doubleParser(0.0)).handler(ctx -> {
            Account target = (Account)ctx.get("target");
            BigDecimal amount = BigDecimal.valueOf((Double)ctx.get("amount"));
            Banco.get().getAccountManager().deposit(target, amount);
            MessageUtil.success((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco.give.success", (ComponentLike[])new ComponentLike[]{Component.text((String)target.getName()), Component.text((String)MessageUtil.format(amount)), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol())}));
        }));
        commandManager.command(bancoCommand.literal("set", new String[0]).permission("banco.use.banco.set").commandDescription(Description.of("Sets an account's balance")).required("target", AccountParser.accountParser()).required("amount", DoubleParser.doubleParser(0.0)).handler(ctx -> {
            Account target = (Account)ctx.get("target");
            BigDecimal amount = BigDecimal.valueOf((Double)ctx.get("amount"));
            Banco.get().getAccountManager().set(target, amount);
            MessageUtil.success((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco.set.success", (ComponentLike[])new ComponentLike[]{Component.text((String)target.getName()), Component.text((String)MessageUtil.format(amount)), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol())}));
        }));
        commandManager.command(bancoCommand.literal("take", new String[0]).permission("banco.use.banco.take").commandDescription(Description.of("Takes funds from an account")).required("target", AccountParser.accountParser()).required("amount", DoubleParser.doubleParser(0.0)).handler(ctx -> {
            Account target = (Account)ctx.get("target");
            BigDecimal amount = BigDecimal.valueOf((Double)ctx.get("amount"));
            BigDecimal accountAmount = target.amount();
            if (!Banco.get().getSettings().get().getCurrency().isNegativeBalance() && amount.compareTo(accountAmount) > 0) {
                MessageUtil.error((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco.take.amount-too-high", (ComponentLike[])new ComponentLike[]{Component.text((String)MessageUtil.format(amount)), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol()), Component.text((String)MessageUtil.format(accountAmount))}));
                return;
            }
            Banco.get().getAccountManager().withdraw(target, amount);
            MessageUtil.success((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco.take.success", (ComponentLike[])new ComponentLike[]{Component.text((String)target.getName()), Component.text((String)MessageUtil.format(amount)), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol())}));
        }));
        commandManager.command(bancoCommand.literal("dump", new String[0]).permission("banco.use.banco.dump").commandDescription(Description.of("Dumps the current database into an additional file")).handler(ctx -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMddyyyyHHmm");
            String dateAsString = dateFormat.format(new Date());
            Banco.get().getAccountManager().getDatabase().backup(dateAsString);
            MessageUtil.debug((Audience)ctx.sender(), "Database has been dumped into accounts.db." + dateAsString + "!");
        }));
        commandManager.command(bancoCommand.literal("info", new String[0]).permission("banco.use.banco.info").commandDescription(Description.of("Displays information about the plugin")).flag(CommandFlag.builder("text")).handler(ctx -> {
            if (!((BancoCommandSource)ctx.sender()).isPlayer() || ctx.flags().contains("text")) {
                String version = Banco.get().version();
                String latest = UpdateChecker.getLatest();
                MessageUtil.info((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco", (ComponentLike[])new ComponentLike[]{Component.text((String)version), Component.text((String)BancoCommand.getBancoBuildSoftware())}));
                if (!version.equals(latest)) {
                    MessageUtil.info((Audience)ctx.sender(), Component.translatable((String)"banco.commands.banco.new-version", (ComponentLike[])new ComponentLike[]{Component.text((String)latest)}).clickEvent(ClickEvent.openUrl((String)("https://github.com/myth-MC/banco/releases/tag/" + latest))));
                }
                MessageUtil.debug((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco.debug.1", (ComponentLike[])new ComponentLike[]{Component.text((String)Bukkit.getBukkitVersion())}));
                MessageUtil.debug((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco.debug.2", (ComponentLike[])new ComponentLike[]{Component.text((boolean)Bukkit.getServer().getOnlineMode())}));
                MessageUtil.debug((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.banco.debug.3", (ComponentLike[])new ComponentLike[]{Component.text((int)Banco.get().getItemRegistry().get().size()), Component.text((int)Banco.get().getStorageRegistry().get().size()), Component.text((int)Banco.get().getAccountManager().get().size()), Component.text((int)Banco.get().getAccountManager().getDatabase().getCachedAccounts().size()), Component.text((int)BancoScheduler.get().getQueuedTransactions().size())}));
            } else {
                ((BancoBootstrap)Banco.get()).menuDispatcher().showInfo((Player)((BancoCommandSource)ctx.sender()).source());
            }
        }));
        commandManager.command(bancoCommand.literal("reload", new String[0]).permission("banco.use.banco.reload").commandDescription(Description.of("Reloads the plugin's configuration")).handler(ctx -> {
            MessageUtil.info((Audience)ctx.sender(), "banco.commands.banco.reload");
            Banco.get().reload();
            MessageUtil.success((Audience)ctx.sender(), "banco.commands.banco.reload.success");
        }));
        if (Banco.get().getSettings().get().isDebug()) {
            commandManager.command(bancoCommand.literal("debug", new String[0]).literal("forcesave", new String[0]).optional("account", AccountParser.accountParser()).permission("banco.use.banco.debug.forcesave").commandDescription(Description.of("Forces a database save")).handler(ctx -> {
                if (ctx.contains("account")) {
                    Account account = (Account)ctx.get("account");
                    long totalTime = Banco.get().getAccountManager().getDatabase().updateDatabaseEntry(account);
                    MessageUtil.debug((Audience)ctx.sender(), String.format("Done! (took %sms)", totalTime));
                    return;
                }
                long totalTime = Banco.get().getAccountManager().getDatabase().updateAllDatabaseEntries();
                MessageUtil.debug((Audience)ctx.sender(), String.format("Done! (took %sms)", totalTime));
            }));
        }
    }

    private static String getBancoBuildSoftware() {
        try {
            Class.forName("ovh.mythmc.banco.paper.BancoPaperPlugin");
            return "paper";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "bukkit";
        }
    }
}

