/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.listeners;

import java.util.UUID;
import org.bukkit.Bukkit;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.callback.item.BancoItemRegisterCallback;
import ovh.mythmc.banco.api.callback.transaction.BancoTransactionProcessCallback;

public final class BancoListener {
    private static final String DEBUG_KEY = "banco:debug";

    public void registerCallbacks() {
        BancoTransactionProcessCallback.INSTANCE.registerListener(DEBUG_KEY, (transaction, cancelled) -> {
            if (!Banco.get().getSettings().get().isDebug()) {
                return;
            }
            Banco.get().getLogger().info("Transaction ({}|{}): {} - operation: {} - cancelled: {}", new Object[]{transaction.account().getUuid(), Bukkit.getOfflinePlayer((UUID)transaction.account().getUuid()).getName(), transaction.amount(), transaction.operation(), cancelled});
        });
        BancoItemRegisterCallback.INSTANCE.registerListener(DEBUG_KEY, item -> {
            if (!Banco.get().getSettings().get().isDebug()) {
                return;
            }
            Banco.get().getLogger().info("Registered ItemStack {} with value {}", item.asItemStack(), item.value());
        });
    }

    public void unregisterCallbacks() {
        BancoTransactionProcessCallback.INSTANCE.unregisterListeners(DEBUG_KEY);
        BancoItemRegisterCallback.INSTANCE.unregisterListeners(DEBUG_KEY);
    }
}

